/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.dto;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;
import org.mule.runtime.extension.api.error.ErrorMapping;

public class ParameterValueContainer {
    private Object object = null;
    private Boolean aBoolean = null;
    private String aString = null;
    private Character character = null;
    private Byte aByte = null;
    private Short aShort = null;
    private Integer anInteger = null;
    private Long aLong = null;
    private Float aFloat = null;
    private Double aDouble = null;
    private String expression = null;
    private ComponentAstDTO singlePojoComponentAstDto = null;
    private List<ComponentAstDTO> listOfPojoComponentAstDto = null;
    private List<ErrorMapping> listOfErrorMappings = null;

    public ParameterValueContainer(String expression, Object fixedValue) {
        if (Stream.of(expression, fixedValue).filter(obj -> !Objects.isNull(obj)).count() > 1L) {
            throw new IllegalArgumentException("Only one parameter can be not null");
        }
        if (expression != null) {
            this.expression = expression;
            return;
        }
        if (fixedValue instanceof Boolean) {
            this.aBoolean = (Boolean)fixedValue;
            return;
        }
        if (fixedValue instanceof String) {
            this.aString = (String)fixedValue;
            return;
        }
        if (fixedValue instanceof Character) {
            this.character = (Character)fixedValue;
            return;
        }
        if (fixedValue instanceof Byte) {
            this.aByte = (Byte)fixedValue;
            return;
        }
        if (fixedValue instanceof Short) {
            this.aShort = (Short)fixedValue;
            return;
        }
        if (fixedValue instanceof Integer) {
            this.anInteger = (Integer)fixedValue;
            return;
        }
        if (fixedValue instanceof Long) {
            this.aLong = (Long)fixedValue;
            return;
        }
        if (fixedValue instanceof Float) {
            this.aFloat = (Float)fixedValue;
            return;
        }
        if (fixedValue instanceof Double) {
            this.aDouble = (Double)fixedValue;
            return;
        }
        if (fixedValue instanceof ComponentAstDTO) {
            this.singlePojoComponentAstDto = (ComponentAstDTO)((Object)fixedValue);
            return;
        }
        if (this.isAListOfComponentAstDTOs(fixedValue)) {
            this.listOfPojoComponentAstDto = (List)fixedValue;
            return;
        }
        if (this.isAListOfErrorMappings(fixedValue)) {
            this.listOfErrorMappings = (List)fixedValue;
            return;
        }
        this.object = fixedValue;
    }

    public Object getContainedValue() {
        return Stream.of(new Object[]{this.object, this.aBoolean, this.aString, this.character, this.aByte, this.aShort, this.anInteger, this.aLong, this.aFloat, this.aDouble, this.expression, this.singlePojoComponentAstDto, this.listOfPojoComponentAstDto, this.listOfErrorMappings}).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public String toString() {
        if (this.object != null) {
            return "ParameterValueContainer{object=" + this.object + '}';
        }
        if (this.aBoolean != null) {
            return "ParameterValueContainer{aBoolean=" + this.aBoolean + '}';
        }
        if (this.aString != null) {
            return "ParameterValueContainer{aString=" + this.aString + '}';
        }
        if (this.character != null) {
            return "ParameterValueContainer{character=" + this.character + '}';
        }
        if (this.aByte != null) {
            return "ParameterValueContainer{aByte=" + this.aByte + '}';
        }
        if (this.aShort != null) {
            return "ParameterValueContainer{aShort=" + this.aShort + '}';
        }
        if (this.anInteger != null) {
            return "ParameterValueContainer{anInteger=" + this.anInteger + '}';
        }
        if (this.aLong != null) {
            return "ParameterValueContainer{aLong=" + this.aLong + '}';
        }
        if (this.aFloat != null) {
            return "ParameterValueContainer{aFloat=" + this.aFloat + '}';
        }
        if (this.aDouble != null) {
            return "ParameterValueContainer{aDouble=" + this.aDouble + '}';
        }
        if (this.expression != null) {
            return "ParameterValueContainer{expression=" + this.expression + '}';
        }
        if (this.singlePojoComponentAstDto != null) {
            return "ParameterValueContainer{singlePojoComponentAstDto=" + (Object)((Object)this.singlePojoComponentAstDto) + '}';
        }
        if (this.listOfPojoComponentAstDto != null) {
            return "ParameterValueContainer{listOfPojoComponentAstDto=" + this.listOfPojoComponentAstDto + '}';
        }
        if (this.listOfErrorMappings != null) {
            return "ParameterValueContainer{listOfErrorMappings=" + this.listOfErrorMappings + '}';
        }
        return "ParameterValueContainer{}";
    }

    public boolean isExpression() {
        return this.expression != null;
    }

    public boolean isFixedValue() {
        return this.expression == null;
    }

    public String getExpression() {
        return this.expression;
    }

    public Object getFixedValue() {
        return Stream.of(new Object[]{this.object, this.aBoolean, this.aString, this.character, this.aByte, this.aShort, this.anInteger, this.aLong, this.aFloat, this.aDouble, this.singlePojoComponentAstDto, this.listOfPojoComponentAstDto, this.listOfErrorMappings}).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Optional<Object> getValue() {
        return Optional.ofNullable(this.getContainedValue());
    }

    private boolean isAListOfComponentAstDTOs(Object right) {
        return right instanceof List && !((List)right).isEmpty() && ((List)right).get(0) instanceof ComponentAstDTO;
    }

    private boolean isAListOfErrorMappings(Object right) {
        return right instanceof List && !((List)right).isEmpty() && ((List)right).get(0) instanceof ErrorMapping;
    }
}

