/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.dto;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.serialization.ExtensionModelResolver;
import org.mule.runtime.ast.api.util.BaseArtifactAst;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.error.ErrorTypeRepositoryBuildingUtils;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.EnrichedErrorTypeRepository;
import org.mule.runtime.ast.internal.serialization.dto.ErrorTypeRepositoryDTO;
import org.mule.runtime.ast.internal.serialization.dto.ExtensionModelDTO;
import org.mule.runtime.ast.internal.serialization.dto.ImportedResourceDTO;
import org.mule.runtime.ast.internal.serialization.resolver.GenerationInformationResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactAstDTO
extends BaseArtifactAst
implements ArtifactAst {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactAstDTO.class);
    private final String artifactName;
    private final ArtifactType artifactType;
    private final Set<ExtensionModelDTO> dependencies;
    private final List<ComponentAstDTO> topLevelComponentAsts;
    private final ErrorTypeRepositoryDTO errorTypeRepository;
    private final Collection<ImportedResourceDTO> importedResources;
    private transient ArtifactAst parent;
    private transient Set<ExtensionModel> dependenciesTransient = new HashSet<ExtensionModel>();
    private transient PropertiesResolver propertiesResolver;

    public ArtifactAstDTO(String artifactName, ArtifactType artifactType, Set<ExtensionModelDTO> dependencies, List<ComponentAstDTO> topLevelComponentAsts, ErrorTypeRepositoryDTO errorTypeRepository, Collection<ImportedResourceDTO> importedResources) {
        this.artifactName = artifactName;
        this.artifactType = artifactType;
        this.dependencies = dependencies;
        this.topLevelComponentAsts = topLevelComponentAsts;
        this.errorTypeRepository = errorTypeRepository;
        this.importedResources = importedResources;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    public Set<ExtensionModel> dependencies() {
        return Collections.unmodifiableSet(this.dependenciesTransient);
    }

    public Optional<ArtifactAst> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public List<ComponentAst> topLevelComponents() {
        return Collections.unmodifiableList(this.topLevelComponentAsts);
    }

    public void updatePropertiesResolver(UnaryOperator<String> newPropertiesResolver) {
        this.propertiesResolver.setMappingFunction(newPropertiesResolver);
    }

    public ErrorTypeRepository getErrorTypeRepository() {
        return this.errorTypeRepository;
    }

    public Collection<ImportedResource> getImportedResources() {
        return Collections.unmodifiableCollection(this.importedResources);
    }

    public PropertiesResolver getPropertiesResolver() {
        return this.propertiesResolver;
    }

    public void setPropertiesResolver(PropertiesResolver propertiesResolver) {
        this.propertiesResolver = propertiesResolver;
        this.topLevelComponentAsts.forEach(componentAstDTO -> componentAstDTO.setPropertiesResolver(propertiesResolver));
        this.importedResources.forEach(importedResource -> importedResource.setPropertiesResolver(propertiesResolver));
    }

    public void setParent(ArtifactAst parent) {
        this.parent = parent;
    }

    public void enrich(ExtensionModelResolver extensionModelResolver, GenerationInformationResolver generationInformationResolver) {
        LOGGER.debug("Enriching importResources...");
        Map importResourcesByRawLocation = this.importedResources.stream().collect(Collectors.toMap(ImportedResourceDTO::getRawResourceLocation, UnaryOperator.identity()));
        this.topLevelComponentAsts.forEach(componentAst -> componentAst.enrichWithImportedResources(importResourcesByRawLocation));
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        propertiesResolver.setMappingFunction(UnaryOperator.identity());
        this.setPropertiesResolver(propertiesResolver);
        LOGGER.debug("Enrichment: resolving dependencies...");
        this.dependenciesTransient = this.dependencies.stream().map(dto -> {
            ExtensionModel resolvedExtModel = extensionModelResolver.resolve(dto.getName());
            if (resolvedExtModel == null) {
                LOGGER.warn("No extension model named '{}' found", (Object)dto.getName());
            }
            return resolvedExtModel;
        }).filter(extModel -> extModel != null).collect(Collectors.toSet());
        ExtensionModelHelper extensionModelHelper = new ExtensionModelHelper(this.dependenciesTransient);
        LOGGER.debug("Enriching models...");
        this.topLevelComponentAsts.stream().filter(topLevelComponent -> topLevelComponent.getExtensionModelDTO() != null).forEach(topLevelComponent -> topLevelComponent.resolveModelsRecursively(null, extensionModelHelper, extensionModelResolver, generationInformationResolver));
    }

    public ErrorTypeRepository enrichedErrorTypeRepository() {
        EnrichedErrorTypeRepository enrichedErrorRepository = new EnrichedErrorTypeRepository(this.errorTypeRepository);
        ErrorTypeRepositoryBuildingUtils.addErrorsFromArtifact((ArtifactAst)this, (ErrorTypeRepository)enrichedErrorRepository);
        return enrichedErrorRepository;
    }
}

