/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.scheduler;

import org.hamcrest.core.IsInstanceOf;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.scheduler.SchedulerConfig;

public class SchedulerConfigTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    public void invalidLowPriority() {
        this.assertInvalidPriorityIsRejected(0);
    }

    @Test
    public void invalidHighPriority() {
        this.assertInvalidPriorityIsRejected(11);
    }

    private void assertInvalidPriorityIsRejected(int priority) {
        this.expected.expect(IsInstanceOf.instanceOf(IllegalArgumentException.class));
        this.expected.expectMessage(String.format("'priority' must be in the range [1, 10]. %d passed", priority));
        SchedulerConfig.config().withPriority(priority);
    }
}

