/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util.classloader;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.internal.util.classloader.CallerClassUtils;

public class MuleImplementationLoaderUtils {
    private static final boolean DYNAMIC_RESOLUTION = Boolean.getBoolean("mule.resolve.mule.implementations.loader.dynamically");
    private static final String MULE_RUNTIME_CORE_API_CLASS = "org.mule.runtime.core.api.MuleContext";
    private static final ConcurrentMap<ClassLoader, ClassLoader> muleImplementationsLoaders = new ConcurrentHashMap<ClassLoader, ClassLoader>();
    private static ClassLoader muleImplementationsLoader;
    private static boolean forceLookup;

    private MuleImplementationLoaderUtils() {
    }

    public static boolean isResolveMuleImplementationLoadersDynamically() {
        return DYNAMIC_RESOLUTION;
    }

    public static ClassLoader getMuleImplementationsLoader() {
        if (!MuleImplementationLoaderUtils.isResolveMuleImplementationLoadersDynamically()) {
            return muleImplementationsLoader != null ? muleImplementationsLoader : MuleImplementationLoaderUtils.class.getClassLoader();
        }
        if (forceLookup) {
            ClassLoader nonMuleApiClassLoader = CallerClassUtils.getCallerClassClassLoader(MULE_RUNTIME_CORE_API_CLASS);
            return muleImplementationsLoaders.computeIfAbsent(nonMuleApiClassLoader, key -> {
                try {
                    return nonMuleApiClassLoader.loadClass(MULE_RUNTIME_CORE_API_CLASS).getClassLoader();
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return muleImplementationsLoader;
    }

    public static void setMuleImplementationsLoader(ClassLoader classLoader) {
        Preconditions.checkState(muleImplementationsLoader == null, "'muleImplementationsLoader' has been already set");
        Preconditions.checkState(!forceLookup, "Implementation loaders will be dynamically looked up");
        Preconditions.checkArgument(classLoader != null, "'classLoader' can't be null");
        muleImplementationsLoader = classLoader;
    }

    public static void forceLookup() {
        Preconditions.checkState(muleImplementationsLoader == null, "'muleImplementationsLoader' has been set");
        forceLookup = true;
    }

    static {
        forceLookup = false;
    }
}

