/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.commons.lang3.StringUtils;

public final class MediaType
implements Serializable {
    private static final long serialVersionUID = -3626429370741009489L;
    private static final String CHARSET_PARAM = "charset";
    private static final String TYPE_TEXT = "text";
    private static final String TYPE_APPLICATION = "application";
    private static final String TYPE_MULTIPART = "multipart";
    private static final String SUBTYPE_JSON = "json";
    private static final String SUBTYPE_XML = "xml";
    private static final String SUBTYPE_PLAIN = "plain";
    private static final String SUBTYPE_HTML = "html";
    private static final String SUBTYPE_OCTET_STREAM = "octet-stream";
    private static final String SUBTYPE_MIXED = "mixed";
    private static final String SUBTYPE_FORM_DATA = "form-data";
    private static final String SUBTYPE_RELATED = "related";
    private static final Cache<String, MediaType> cache = Caffeine.newBuilder().maximumSize(32L).build();
    public static final MediaType ANY;
    public static final MediaType JSON;
    public static final MediaType APPLICATION_JSON;
    public static final MediaType APPLICATION_JAVA;
    public static final MediaType ATOM;
    public static final MediaType RSS;
    public static final MediaType APPLICATION_XML;
    public static final MediaType XML;
    public static final MediaType TEXT;
    public static final MediaType HTML;
    public static final MediaType BINARY;
    public static final MediaType UNKNOWN;
    public static final MediaType MULTIPART_MIXED;
    public static final MediaType MULTIPART_FORM_DATA;
    public static final MediaType MULTIPART_RELATED;
    public static final MediaType MULTIPART_X_MIXED_REPLACE;
    private static Map<String, MediaType> predefined;
    private static List<String> KNOWN_PARAM_NAMES;
    private final String primaryType;
    private final String subType;
    private final Map<String, String> params;
    private boolean definedInApp = false;
    private transient Object withoutParamsLock = new Object();
    private volatile transient MediaType withoutParams;
    private transient Charset charset;
    private transient String rfcString;
    private transient Cache<Optional<Charset>, MediaType> withCharsetCache = Caffeine.newBuilder().maximumSize(16L).build();

    public static MediaType parse(String mediaType) {
        return MediaType.getKnown(mediaType).orElseGet(() -> MediaType.parseMediaType(mediaType, false));
    }

    public static MediaType parseDefinedInApp(String mediaType) {
        return MediaType.getKnown(mediaType).orElseGet(() -> MediaType.parseMediaType(mediaType, true));
    }

    private static Optional<MediaType> getKnown(String mediaType) {
        MediaType predefinedFound = predefined.get(mediaType);
        if (predefinedFound != null) {
            return Optional.of(predefinedFound);
        }
        MediaType cachedFound = (MediaType)cache.getIfPresent((Object)mediaType);
        if (cachedFound != null) {
            return Optional.of(cachedFound);
        }
        return Optional.empty();
    }

    private static MediaType parseMediaType(String mediaType, boolean definedInApp) {
        try {
            boolean isDefinedInApp;
            MimeType mimeType = new MimeType(mediaType);
            String charsetParam = mimeType.getParameter(CHARSET_PARAM);
            Charset charset = StringUtils.isNotEmpty((CharSequence)charsetParam) ? Charset.forName(charsetParam) : null;
            HashMap<String, String> params = new HashMap<String, String>();
            for (String paramName : Collections.list(mimeType.getParameters().getNames())) {
                if (CHARSET_PARAM.equals(paramName)) continue;
                params.put(paramName, mimeType.getParameter(paramName));
            }
            boolean bl = isDefinedInApp = definedInApp || params.isEmpty();
            if (!isDefinedInApp && !KNOWN_PARAM_NAMES.isEmpty()) {
                Set paramNames = params.keySet();
                isDefinedInApp = KNOWN_PARAM_NAMES.containsAll(paramNames);
            }
            MediaType value = new MediaType(mimeType.getPrimaryType(), mimeType.getSubType(), params, charset, isDefinedInApp);
            if (params.isEmpty()) {
                return MediaType.cacheMediaType(value, mediaType, definedInApp);
            }
            return value;
        }
        catch (MimeTypeParseException e) {
            throw new IllegalArgumentException("MediaType cannot be parsed: " + mediaType, e);
        }
    }

    static void setKnownParamNames(List<String> knownParamNames) {
        KNOWN_PARAM_NAMES = knownParamNames;
    }

    public static MediaType create(String primaryType, String subType) {
        return MediaType.create(primaryType, subType, null);
    }

    private static MediaType createConstant(String primaryType, String subType) {
        MediaType value = new MediaType(primaryType, subType, Collections.emptyMap(), null, true);
        predefined.put(value.toRfcString(), value);
        return value;
    }

    public static MediaType create(String primaryType, String subType, Charset charset) {
        MediaType value = new MediaType(primaryType, subType, Collections.emptyMap(), charset, true);
        MediaType cachedMediaType = MediaType.cacheMediaType(value, value.toRfcString(), false);
        return cachedMediaType;
    }

    private static MediaType cacheMediaType(MediaType type, String rfcString, boolean definedInApp) {
        MediaType oldValue = (MediaType)cache.getIfPresent((Object)rfcString);
        if (oldValue == null) {
            cache.put((Object)rfcString, (Object)type);
            cache.cleanUp();
            return type;
        }
        return oldValue;
    }

    private MediaType(String primaryType, String subType, Map<String, String> params, Charset charset, boolean definedInApp) {
        this.primaryType = primaryType;
        this.subType = subType;
        this.params = params;
        this.charset = charset;
        this.definedInApp = definedInApp;
        this.rfcString = this.calculateRfcString();
    }

    public MediaType withCharset(Charset charset) {
        return (MediaType)this.withCharsetCache.get(Optional.ofNullable(charset), c -> new MediaType(this.getPrimaryType(), this.getSubType(), this.params, c.orElse(null), this.definedInApp));
    }

    public MediaType withParamaters(Map<String, String> params) {
        if (!params.isEmpty()) {
            return new MediaType(this.getPrimaryType(), this.getSubType(), params, this.charset, this.definedInApp);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaType withoutParameters() {
        if (this.withoutParams == null) {
            Object object = this.withoutParamsLock;
            synchronized (object) {
                if (this.withoutParams == null) {
                    this.withoutParams = MediaType.create(this.getPrimaryType(), this.getSubType());
                }
            }
        }
        return this.withoutParams;
    }

    public boolean isDefinedInApp() {
        return this.definedInApp;
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public String getSubType() {
        return this.subType;
    }

    public Optional<Charset> getCharset() {
        return Optional.ofNullable(this.charset);
    }

    public String getParameter(String paramName) {
        return this.params.get(paramName);
    }

    public boolean matches(MediaType other) {
        return Objects.equals(this.primaryType, other.primaryType) && Objects.equals(this.subType, other.subType);
    }

    public String toRfcString() {
        return this.rfcString;
    }

    public String toString() {
        return this.toRfcString();
    }

    public int hashCode() {
        return Objects.hash(this.primaryType, this.subType, this.charset, this.params, this.definedInApp);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        MediaType other = (MediaType)obj;
        return Objects.equals(this.primaryType, other.primaryType) && Objects.equals(this.subType, other.subType) && Objects.equals(this.params, other.params) && Objects.equals(this.definedInApp, other.definedInApp) && Objects.equals(this.charset, other.charset);
    }

    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        String charsetStr = (String)in.readObject();
        if (charsetStr != null) {
            this.charset = Charset.forName(charsetStr);
        }
        this.withCharsetCache = Caffeine.newBuilder().maximumSize(16L).build();
        this.withoutParamsLock = new Object();
        this.rfcString = this.calculateRfcString();
    }

    protected String calculateRfcString() {
        String typeSubtype = this.primaryType + "/" + this.subType;
        if (this.charset == null && this.params.isEmpty()) {
            return typeSubtype;
        }
        if (this.params.isEmpty()) {
            return typeSubtype + "; charset=" + this.charset.name();
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(typeSubtype);
        if (this.charset != null) {
            buffer.append("; charset=" + this.charset.name());
        }
        if (!this.params.isEmpty()) {
            this.params.forEach((k, v) -> buffer.append("; ").append((String)k).append("=\"").append(this.quote((String)v)).append("\""));
        }
        return buffer.toString();
    }

    private void writeObject(ObjectOutputStream out) throws Exception {
        out.defaultWriteObject();
        if (this.charset != null) {
            out.writeObject(this.charset.name());
        } else {
            out.writeObject(null);
        }
    }

    private String quote(String value) {
        int length = value.length();
        StringBuffer buffer = new StringBuffer();
        buffer.ensureCapacity(new Double((double)length * 1.5).intValue());
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c == '\\' || c == '\"') {
                buffer.append('\\');
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static int getCacheSize() {
        return cache.asMap().size();
    }

    static {
        predefined = new HashMap<String, MediaType>(16);
        ANY = MediaType.createConstant("*", "*");
        JSON = MediaType.createConstant(TYPE_TEXT, SUBTYPE_JSON);
        APPLICATION_JSON = MediaType.createConstant(TYPE_APPLICATION, SUBTYPE_JSON);
        APPLICATION_JAVA = MediaType.createConstant(TYPE_APPLICATION, "java");
        ATOM = MediaType.createConstant(TYPE_APPLICATION, "atom+xml");
        RSS = MediaType.createConstant(TYPE_APPLICATION, "rss+xml");
        APPLICATION_XML = MediaType.createConstant(TYPE_APPLICATION, SUBTYPE_XML);
        XML = MediaType.createConstant(TYPE_TEXT, SUBTYPE_XML);
        TEXT = MediaType.createConstant(TYPE_TEXT, SUBTYPE_PLAIN);
        HTML = MediaType.createConstant(TYPE_TEXT, SUBTYPE_HTML);
        BINARY = MediaType.createConstant(TYPE_APPLICATION, SUBTYPE_OCTET_STREAM);
        UNKNOWN = MediaType.createConstant("content", "unknown");
        MULTIPART_MIXED = MediaType.createConstant(TYPE_MULTIPART, SUBTYPE_MIXED);
        MULTIPART_FORM_DATA = MediaType.createConstant(TYPE_MULTIPART, SUBTYPE_FORM_DATA);
        MULTIPART_RELATED = MediaType.createConstant(TYPE_MULTIPART, SUBTYPE_RELATED);
        MULTIPART_X_MIXED_REPLACE = MediaType.createConstant(TYPE_MULTIPART, "x-mixed-replace");
        predefined = Collections.unmodifiableMap(predefined);
        KNOWN_PARAM_NAMES = System.getProperty("mule.mediatype.paramNames") != null ? Arrays.asList(System.getProperty("mule.mediatype.paramNames").split(",")) : Collections.emptyList();
    }
}

