/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.scheduler;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class SchedulerConfig {
    private final Integer maxConcurrentTasks;
    private final String schedulerPrefix;
    private final String schedulerName;
    private final Optional<Boolean> waitAllowed;
    private final Optional<Boolean> runCpuLightWhenTargetBusy;
    private final Supplier<Long> shutdownTimeoutMillis;
    private final Optional<Integer> priority;

    public static SchedulerConfig config() {
        return new SchedulerConfig();
    }

    private SchedulerConfig() {
        this.maxConcurrentTasks = null;
        this.schedulerPrefix = null;
        this.schedulerName = null;
        this.waitAllowed = Optional.empty();
        this.runCpuLightWhenTargetBusy = Optional.empty();
        this.shutdownTimeoutMillis = () -> null;
        this.priority = Optional.empty();
    }

    private SchedulerConfig(Integer maxConcurrentTasks, String schedulerPrefix, String schedulerName, Optional<Boolean> waitAllowed, Optional<Boolean> runCpuLightWhenTargetBusy, Supplier<Long> shutdownTimeoutMillis, Optional<Integer> priority) {
        this.maxConcurrentTasks = maxConcurrentTasks;
        this.schedulerPrefix = schedulerPrefix;
        this.schedulerName = schedulerName;
        this.waitAllowed = waitAllowed;
        this.runCpuLightWhenTargetBusy = runCpuLightWhenTargetBusy;
        this.shutdownTimeoutMillis = shutdownTimeoutMillis;
        this.priority = priority;
    }

    public SchedulerConfig withMaxConcurrentTasks(int maxConcurrentTasks) {
        return new SchedulerConfig(maxConcurrentTasks, this.schedulerPrefix, this.schedulerName, this.waitAllowed, this.runCpuLightWhenTargetBusy, this.shutdownTimeoutMillis, this.priority);
    }

    public Integer getMaxConcurrentTasks() {
        return this.maxConcurrentTasks;
    }

    public SchedulerConfig withPrefix(String schedulerPrefix) {
        return new SchedulerConfig(this.maxConcurrentTasks, schedulerPrefix, this.schedulerName, this.waitAllowed, this.runCpuLightWhenTargetBusy, this.shutdownTimeoutMillis, this.priority);
    }

    public SchedulerConfig withName(String schedulerName) {
        return new SchedulerConfig(this.maxConcurrentTasks, this.schedulerPrefix, schedulerName, this.waitAllowed, this.runCpuLightWhenTargetBusy, this.shutdownTimeoutMillis, this.priority);
    }

    public String getSchedulerName() {
        return this.schedulerPrefix == null ? this.schedulerName : String.format("[%s].%s", this.schedulerPrefix, this.schedulerName);
    }

    public boolean hasName() {
        return this.schedulerName != null;
    }

    public SchedulerConfig withDirectRunCpuLightWhenTargetBusy(boolean runCpuLightWhenTargetBusy) {
        return new SchedulerConfig(this.maxConcurrentTasks, this.schedulerPrefix, this.schedulerName, this.waitAllowed, Optional.of(runCpuLightWhenTargetBusy), this.shutdownTimeoutMillis, this.priority);
    }

    public Optional<Boolean> getDirectRunCpuLightWhenTargetBusy() {
        return this.runCpuLightWhenTargetBusy;
    }

    public SchedulerConfig withWaitAllowed(boolean waitAllowed) {
        return new SchedulerConfig(this.maxConcurrentTasks, this.schedulerPrefix, this.schedulerName, Optional.of(waitAllowed), this.runCpuLightWhenTargetBusy, this.shutdownTimeoutMillis, this.priority);
    }

    public Optional<Boolean> getWaitAllowed() {
        return this.waitAllowed;
    }

    public SchedulerConfig withShutdownTimeout(Supplier<Long> shutdownTimeoutSupplier, TimeUnit shutdownTimeoutUnit) {
        Objects.requireNonNull(shutdownTimeoutUnit);
        return new SchedulerConfig(this.maxConcurrentTasks, this.schedulerPrefix, this.schedulerName, this.waitAllowed, this.runCpuLightWhenTargetBusy, () -> {
            long shutdownTimeout = (Long)shutdownTimeoutSupplier.get();
            this.validateTimeoutValue(shutdownTimeout);
            return shutdownTimeoutUnit.toMillis(shutdownTimeout);
        }, this.priority);
    }

    public SchedulerConfig withShutdownTimeout(long shutdownTimeout, TimeUnit shutdownTimeoutUnit) {
        Objects.requireNonNull(shutdownTimeoutUnit);
        this.validateTimeoutValue(shutdownTimeout);
        return this.withShutdownTimeout(() -> shutdownTimeout, shutdownTimeoutUnit);
    }

    private void validateTimeoutValue(long shutdownTimeout) {
        if (shutdownTimeout < 0L) {
            throw new IllegalArgumentException(String.format("'shutdownTimeout' must be a possitive long. %d passed", shutdownTimeout));
        }
    }

    public Supplier<Long> getShutdownTimeoutMillis() {
        return this.shutdownTimeoutMillis;
    }

    public SchedulerConfig withPriority(int priority) {
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException(String.format("'priority' must be in the range [%d, %d]. %d passed", 1, 10, priority));
        }
        return new SchedulerConfig(this.maxConcurrentTasks, this.schedulerPrefix, this.schedulerName, this.waitAllowed, this.runCpuLightWhenTargetBusy, this.shutdownTimeoutMillis, Optional.of(priority));
    }

    public Optional<Integer> getPriority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchedulerConfig that = (SchedulerConfig)o;
        if (this.maxConcurrentTasks != null ? !this.maxConcurrentTasks.equals(that.maxConcurrentTasks) : that.maxConcurrentTasks != null) {
            return false;
        }
        if (this.schedulerPrefix != null ? !this.schedulerPrefix.equals(that.schedulerPrefix) : that.schedulerPrefix != null) {
            return false;
        }
        if (this.schedulerName != null ? !this.schedulerName.equals(that.schedulerName) : that.schedulerName != null) {
            return false;
        }
        if (this.waitAllowed != null ? !this.waitAllowed.equals(that.waitAllowed) : that.waitAllowed != null) {
            return false;
        }
        if (!this.priority.equals(that.priority)) {
            return false;
        }
        return this.shutdownTimeoutMillis != null ? this.shutdownTimeoutMillis.equals(that.shutdownTimeoutMillis) : that.shutdownTimeoutMillis == null;
    }

    public int hashCode() {
        int result = this.maxConcurrentTasks != null ? this.maxConcurrentTasks.hashCode() : 0;
        result = 31 * result + (this.schedulerPrefix != null ? this.schedulerPrefix.hashCode() : 0);
        result = 31 * result + (this.schedulerName != null ? this.schedulerName.hashCode() : 0);
        result = 31 * result + (this.waitAllowed != null ? this.waitAllowed.hashCode() : 0);
        result = 31 * result + (this.shutdownTimeoutMillis != null ? this.shutdownTimeoutMillis.hashCode() : 0);
        result = 31 * result + this.priority.hashCode();
        return result;
    }
}

