/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.util.classloader;

import java.util.Arrays;
import java.util.List;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CallerClassUtils {
    private CallerClassUtils() {
    }

    public static ClassLoader getCallerClassClassLoader(String accessibleClassName) {
        return new CallingClasses().getCallingClasses().stream().map(Class::getClassLoader).filter(classLoader -> classLoader != null && classLoader != CallerClassUtils.class.getClassLoader()).filter(classLoader -> {
            try {
                classLoader.loadClass(accessibleClassName).getClassLoader();
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }).findFirst().orElseThrow(() -> new RuntimeException("Class loader not found"));
    }

    private static class CallingClasses
    extends SecurityManager {
        CallingClasses() {
        }

        public List<Class<?>> getCallingClasses() {
            return Arrays.asList(this.getClassContext());
        }
    }
}

