/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import org.mule.runtime.api.util.Preconditions;

public class LazyLong
implements LongSupplier {
    private volatile boolean initialized = false;
    private long value;
    private LongSupplier valueSupplier;

    public LazyLong(LongSupplier supplier) {
        Preconditions.checkArgument(supplier != null, "supplier cannot be null");
        this.valueSupplier = supplier;
    }

    public LazyLong(long value) {
        this.value = value;
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAsLong() {
        if (!this.initialized) {
            LazyLong lazyLong = this;
            synchronized (lazyLong) {
                if (!this.initialized) {
                    this.value = this.valueSupplier.getAsLong();
                    this.valueSupplier = () -> this.value;
                    this.initialized = true;
                }
            }
        }
        return this.value;
    }

    public boolean isComputed() {
        return this.initialized;
    }

    public void ifComputed(LongConsumer consumer) {
        if (this.initialized) {
            consumer.accept(this.value);
        }
    }

    public <R> R flatMap(Function<Long, R> function) {
        return function.apply(this.getAsLong());
    }
}

