/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.declaration.fluent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithParametersDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSemanticTermsDeclaration;
import org.mule.runtime.api.util.Preconditions;

public abstract class ParameterizedDeclaration<T extends ParameterizedDeclaration>
extends NamedDeclaration<T>
implements WithParametersDeclaration,
WithSemanticTermsDeclaration {
    private final Map<String, ParameterGroupDeclaration> parameterGroups = new LinkedHashMap<String, ParameterGroupDeclaration>();
    private final Set<String> semanticTerms = new LinkedHashSet<String>();

    ParameterizedDeclaration(String name) {
        super(name);
    }

    @Override
    public List<ParameterGroupDeclaration> getParameterGroups() {
        return Collections.unmodifiableList(new ArrayList<ParameterGroupDeclaration>(this.parameterGroups.values()));
    }

    @Override
    public ParameterGroupDeclaration getParameterGroup(String groupName) {
        Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)groupName), "groupName cannot be blank");
        return this.parameterGroups.computeIfAbsent(groupName, ParameterGroupDeclaration::new);
    }

    public ParameterGroupDeclaration getDefaultParameterGroup() {
        return this.parameterGroups.computeIfAbsent("General", ParameterGroupDeclaration::new);
    }

    @Override
    public List<ParameterDeclaration> getAllParameters() {
        return this.parameterGroups.values().stream().flatMap(g -> g.getParameters().stream()).collect(Collectors.toList());
    }

    @Override
    public void addSemanticTerm(String semanticTerm) {
        Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)semanticTerm), "Semantic term cannot be blank");
        this.semanticTerms.add(semanticTerm);
    }

    @Override
    public Set<String> getSemanticTerms() {
        return this.semanticTerms;
    }
}

