/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.component.execution;

import java.util.function.Consumer;

public interface CompletableCallback<T> {
    public static <T> CompletableCallback<T> empty() {
        return new CompletableCallback<T>(){

            @Override
            public void complete(T value) {
            }

            @Override
            public void error(Throwable e) {
            }
        };
    }

    public static <T> CompletableCallback<T> always(Runnable runnable) {
        return CompletableCallback.empty().finallyAfter(runnable);
    }

    public void complete(T var1);

    public void error(Throwable var1);

    default public CompletableCallback<T> andThen(final Consumer<T> consumer) {
        return this.andThen(new CompletableCallback<T>(){

            @Override
            public void complete(T value) {
                consumer.accept(value);
            }

            @Override
            public void error(Throwable e) {
            }
        });
    }

    default public CompletableCallback<T> andThen(final CompletableCallback<T> afterCallback) {
        return new CompletableCallback<T>(){

            @Override
            public void complete(T value) {
                CompletableCallback.this.complete(value);
                afterCallback.complete(value);
            }

            @Override
            public void error(Throwable e) {
                CompletableCallback.this.error(e);
                afterCallback.error(e);
            }
        };
    }

    default public CompletableCallback<T> before(final Consumer<T> consumer) {
        return this.before(new CompletableCallback<T>(){

            @Override
            public void complete(T value) {
                consumer.accept(value);
            }

            @Override
            public void error(Throwable e) {
            }
        });
    }

    default public CompletableCallback<T> before(final CompletableCallback<T> beforeCallback) {
        return new CompletableCallback<T>(){

            @Override
            public void complete(T value) {
                beforeCallback.complete(value);
                CompletableCallback.this.complete(value);
            }

            @Override
            public void error(Throwable e) {
                beforeCallback.error(e);
                CompletableCallback.this.error(e);
            }
        };
    }

    default public CompletableCallback<T> finallyBefore(final Runnable runnable) {
        return this.before(new CompletableCallback<T>(){

            @Override
            public void complete(T value) {
                runnable.run();
            }

            @Override
            public void error(Throwable e) {
                runnable.run();
            }
        });
    }

    default public CompletableCallback<T> finallyAfter(final Runnable runnable) {
        return this.andThen(new CompletableCallback<T>(){

            @Override
            public void complete(T value) {
                runnable.run();
            }

            @Override
            public void error(Throwable e) {
                runnable.run();
            }
        });
    }
}

