/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.Preconditions;

public final class MediaTypeUtils {
    private static final String TEXT = "text";
    private static final List<MediaType> STRING_REPRESENTABLE_MIME_TYPES = Collections.unmodifiableList(Stream.of("application/json", "application/xml", "application/javascript", "application/rtf", "application/csv", "application/vnd.mozilla.xul+xml", "application/x-csh", "application/x-sh", "application/xhtml+xml", "image/svg+xml", "text/*").map(MediaType::parse).collect(Collectors.toList()));

    private MediaTypeUtils() {
    }

    public static List<MediaType> getStringRepresentableMimeTypes() {
        return STRING_REPRESENTABLE_MIME_TYPES;
    }

    public static boolean isStringRepresentable(MediaType mediaType) {
        Preconditions.checkNotNull(mediaType, "'mediaType' parameter can not be null");
        return mediaType.getPrimaryType().equals(TEXT) || STRING_REPRESENTABLE_MIME_TYPES.stream().anyMatch(type -> type.matches(mediaType));
    }

    public static Charset parseCharset(String charset) {
        try {
            return Charset.forName(charset);
        }
        catch (UnsupportedCharsetException e) {
            throw new IllegalArgumentException("No support is available for the requested charset: " + charset, e);
        }
    }
}

