/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;

public abstract class AbstractComponent
implements Component {
    public static final QName LOCATION_KEY = new QName("http://www.mulesoft.org/schema/mule/parser-metadata", "COMPONENT_LOCATION");
    public static final QName ROOT_CONTAINER_NAME_KEY = new QName("http://www.mulesoft.org/schema/mule/parser-metadata", "ROOT_CONTAINER_NAME");
    public static final QName ANNOTATION_NAME = new QName("config", "componentIdentifier");
    private volatile Map<QName, Object> annotations = Collections.emptyMap();
    private ComponentLocation location;
    private Location rootContainerLocation;
    private ComponentIdentifier identifier;
    private String representation;
    private String dslSource;

    @Override
    public Object getAnnotation(QName qName) {
        return this.annotations.get(qName);
    }

    @Override
    public Map<QName, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    @Override
    public void setAnnotations(Map<QName, Object> newAnnotations) {
        this.annotations = new HashMap<QName, Object>(newAnnotations);
        this.location = (ComponentLocation)this.getAnnotation(LOCATION_KEY);
        this.rootContainerLocation = this.initRootContainerName();
        this.identifier = (ComponentIdentifier)this.getAnnotation(ANNOTATION_NAME);
        this.representation = (String)this.getAnnotation(Component.Annotations.REPRESENTATION_ANNOTATION_KEY);
        this.dslSource = (String)this.getAnnotation(Component.Annotations.SOURCE_ELEMENT_ANNOTATION_KEY);
    }

    protected Location initRootContainerName() {
        String rootContainerName = (String)this.getAnnotation(ROOT_CONTAINER_NAME_KEY);
        if (rootContainerName == null && this.getLocation() != null) {
            rootContainerName = this.getLocation().getRootContainerName();
        }
        return rootContainerName == null ? null : Location.builder().globalName(rootContainerName).build();
    }

    @Override
    public ComponentLocation getLocation() {
        return this.location;
    }

    @Override
    public Location getRootContainerLocation() {
        return this.rootContainerLocation;
    }

    @Override
    public ComponentIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getRepresentation() {
        return this.representation;
    }

    @Override
    public String getDslSource() {
        return this.dslSource;
    }
}

