/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.mule.runtime.api.exception.MuleRuntimeException;

public class NameValidationUtil {
    private static final List<String> SPECIAL_CHARACTERS = Arrays.asList("/", "[", "]", "{", "}", "#");
    private static final Pattern SPECIAL_CHARACTERS_PATTERN = Pattern.compile("[/\\[\\]{}#]");
    private static final Cache<String, Boolean> validIdentifiersCache = CacheBuilder.newBuilder().maximumSize(10000L).build();

    public static void verifyStringDoesNotContainsReservedCharacters(String string) {
        try {
            Boolean isValidIdentifier = (Boolean)validIdentifiersCache.get((Object)string, () -> !SPECIAL_CHARACTERS_PATTERN.matcher(string).find());
            if (!isValidIdentifier.booleanValue()) {
                throw new IllegalArgumentException("Invalid character used in location. Invalid characters are " + String.join((CharSequence)",", SPECIAL_CHARACTERS));
            }
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e);
        }
    }
}

