/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.el.persistence;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.el.validation.ValidationMessage;

public final class ValidationResultTypeAdapter
extends TypeAdapter<ValidationResult> {
    private Gson gson;

    public ValidationResultTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    public void write(JsonWriter jsonWriter, ValidationResult validationResult) throws IOException {
        this.gson.toJson((Object)validationResult, ValidationResult.class, jsonWriter);
    }

    public ValidationResult read(JsonReader jsonReader) throws IOException {
        JsonElement jsonElement = new JsonParser().parse(jsonReader);
        if (jsonElement.isJsonNull()) {
            return null;
        }
        JsonObject validationResult = jsonElement.getAsJsonObject();
        boolean isSuccess = validationResult.get("result").getAsBoolean();
        if (isSuccess) {
            return ValidationResult.success();
        }
        String errorMessage = validationResult.get("errorMessage").getAsString();
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        validationResult.get("messages").getAsJsonArray().forEach(validationMessage -> messages.add((ValidationMessage)this.gson.fromJson(validationMessage, ValidationMessage.class)));
        return ValidationResult.failure(errorMessage, messages);
    }
}

