/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;

abstract class SmallMapDelegate<K, V>
implements Map<K, V>,
Serializable {
    protected transient V previousValue;

    SmallMapDelegate() {
    }

    abstract SmallMapDelegate<K, V> fastPut(K var1, V var2);

    abstract SmallMapDelegate<K, V> fastRemove(Object var1);

    abstract SmallMapDelegate<K, V> copy();

    public V getPreviousValue() {
        V retVal = this.previousValue;
        this.previousValue = null;
        return retVal;
    }

    @Override
    public final V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry entry : this.entrySet()) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(entry.toString());
            first = false;
        }
        return builder.append('}').toString();
    }

    protected abstract class UnmodifiableSet<T>
    implements Set<T> {
        protected UnmodifiableSet() {
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        protected abstract T get(int var1);

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int index = 0;
                private final int size = UnmodifiableSet.this.size();

                @Override
                public boolean hasNext() {
                    return this.index < this.size;
                }

                @Override
                public T next() {
                    int next;
                    if ((next = this.index++) >= this.size) {
                        throw new NoSuchElementException();
                    }
                    return UnmodifiableSet.this.get(next);
                }

                @Override
                public void remove() {
                    throw UnmodifiableSet.this.unmodifiable();
                }
            };
        }

        @Override
        public boolean add(T t) {
            throw this.unmodifiable();
        }

        @Override
        public boolean remove(Object o) {
            throw this.unmodifiable();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object item : c) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw this.unmodifiable();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw this.unmodifiable();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw this.unmodifiable();
        }

        @Override
        public void clear() {
            throw this.unmodifiable();
        }

        @Override
        public boolean removeIf(Predicate<? super T> filter) {
            throw this.unmodifiable();
        }

        private UnsupportedOperationException unmodifiable() {
            return new UnsupportedOperationException("This set is unmodifiable");
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[this.size()];
            int i = 0;
            for (T item : this) {
                array[i++] = item;
            }
            return array;
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            Iterator<T> it = this.iterator();
            for (int i = 0; i < a.length; ++i) {
                a[i] = it.hasNext() ? it.next() : null;
            }
            return a;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Set)) {
                return false;
            }
            Collection c = (Collection)obj;
            if (c.size() != this.size()) {
                return false;
            }
            return this.containsAll(c);
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (T obj : this) {
                if (obj == null) continue;
                h += obj.hashCode();
            }
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("{");
            boolean first = true;
            for (T item : this) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(item);
                first = false;
            }
            return builder.append("}").toString();
        }
    }
}

