/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util.collection;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.mule.runtime.api.util.collection.BiSmallMapDelegate;
import org.mule.runtime.api.util.collection.QuadSmallMapDelegate;
import org.mule.runtime.api.util.collection.SmallMapDelegate;
import org.mule.runtime.api.util.collection.SmallMapEntry;

class TriSmallMapDelegate<K, V>
extends SmallMapDelegate<K, V> {
    private Map.Entry<K, V> entry1;
    private Map.Entry<K, V> entry2;
    private Map.Entry<K, V> entry3;

    public TriSmallMapDelegate(Map.Entry<K, V> entry1, Map.Entry<K, V> entry2, Map.Entry<K, V> entry3, V previousValue) {
        this.entry1 = entry1;
        this.entry2 = entry2;
        this.entry3 = entry3;
        this.previousValue = previousValue;
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return Objects.equals(this.entry1.getKey(), key) || Objects.equals(this.entry2.getKey(), key) || Objects.equals(this.entry3.getKey(), key);
    }

    @Override
    public boolean containsValue(Object value) {
        return Objects.equals(this.entry1.getValue(), value) || Objects.equals(this.entry2.getValue(), value) || Objects.equals(this.entry3.getValue(), value);
    }

    @Override
    public V get(Object key) {
        if (Objects.equals(this.entry1.getKey(), key)) {
            return this.entry1.getValue();
        }
        if (Objects.equals(this.entry2.getKey(), key)) {
            return this.entry2.getValue();
        }
        if (Objects.equals(this.entry3.getKey(), key)) {
            return this.entry3.getValue();
        }
        return null;
    }

    @Override
    public Set<K> keySet() {
        return new SmallMapDelegate.UnmodifiableSet<K>(){

            @Override
            protected K get(int index) {
                switch (index) {
                    case 0: {
                        return TriSmallMapDelegate.this.entry1.getKey();
                    }
                    case 1: {
                        return TriSmallMapDelegate.this.entry2.getKey();
                    }
                }
                return TriSmallMapDelegate.this.entry3.getKey();
            }

            @Override
            public int size() {
                return 3;
            }

            @Override
            public boolean contains(Object o) {
                return TriSmallMapDelegate.this.containsKey(o);
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new SmallMapDelegate.UnmodifiableSet<V>(){

            @Override
            protected V get(int index) {
                switch (index) {
                    case 0: {
                        return TriSmallMapDelegate.this.entry1.getValue();
                    }
                    case 1: {
                        return TriSmallMapDelegate.this.entry2.getValue();
                    }
                }
                return TriSmallMapDelegate.this.entry3.getValue();
            }

            @Override
            public int size() {
                return 3;
            }

            @Override
            public boolean contains(Object o) {
                return TriSmallMapDelegate.this.containsValue(o);
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new SmallMapDelegate.UnmodifiableSet<Map.Entry<K, V>>(){

            @Override
            protected Map.Entry<K, V> get(int index) {
                switch (index) {
                    case 0: {
                        return TriSmallMapDelegate.this.entry1;
                    }
                    case 1: {
                        return TriSmallMapDelegate.this.entry2;
                    }
                }
                return TriSmallMapDelegate.this.entry3;
            }

            @Override
            public int size() {
                return 3;
            }

            @Override
            public boolean contains(Object o) {
                return Objects.equals(o, TriSmallMapDelegate.this.entry1) || Objects.equals(o, TriSmallMapDelegate.this.entry2) || Objects.equals(o, TriSmallMapDelegate.this.entry3);
            }
        };
    }

    @Override
    public SmallMapDelegate<K, V> fastPut(K key, V value) {
        if (Objects.equals(this.entry1.getKey(), key)) {
            this.previousValue = this.entry1.getValue();
            this.entry1 = new SmallMapEntry<K, V>(key, value);
            return this;
        }
        if (Objects.equals(this.entry2.getKey(), key)) {
            this.previousValue = this.entry2.getValue();
            this.entry2 = new SmallMapEntry<K, V>(key, value);
            return this;
        }
        if (Objects.equals(this.entry3.getKey(), key)) {
            this.previousValue = this.entry3.getValue();
            this.entry3 = new SmallMapEntry<K, V>(key, value);
            return this;
        }
        return new QuadSmallMapDelegate<K, Object>(this.entry1, this.entry2, this.entry3, new SmallMapEntry<K, V>(key, value), null);
    }

    @Override
    public SmallMapDelegate<K, V> fastRemove(Object key) {
        if (Objects.equals(this.entry1.getKey(), key)) {
            return new BiSmallMapDelegate<K, V>(this.entry2, this.entry3, this.entry1.getValue());
        }
        if (Objects.equals(this.entry2.getKey(), key)) {
            return new BiSmallMapDelegate<K, V>(this.entry1, this.entry3, this.entry2.getValue());
        }
        if (Objects.equals(this.entry3.getKey(), key)) {
            return new BiSmallMapDelegate<K, V>(this.entry1, this.entry2, this.entry3.getValue());
        }
        this.previousValue = null;
        return this;
    }

    @Override
    SmallMapDelegate<K, V> copy() {
        return new TriSmallMapDelegate<K, Object>(this.entry1, this.entry2, this.entry3, null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriSmallMapDelegate that = (TriSmallMapDelegate)o;
        return Objects.equals(this.entry1, that.entry1) && Objects.equals(this.entry2, that.entry2) && Objects.equals(this.entry3, that.entry3);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entry1, this.entry2, this.entry3);
    }
}

