/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.util;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.function.HasFunctionModels;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.Reference;

public abstract class IdempotentExtensionWalker
extends ExtensionWalker {
    private Set<Reference<SourceModel>> sources = new HashSet<Reference<SourceModel>>();
    private Set<Reference<ParameterModel>> parameters = new HashSet<Reference<ParameterModel>>();
    private Set<Reference<ParameterGroupModel>> parameterGroups = new HashSet<Reference<ParameterGroupModel>>();
    private Set<Reference<OperationModel>> operations = new HashSet<Reference<OperationModel>>();
    private Set<Reference<FunctionModel>> functions = new HashSet<Reference<FunctionModel>>();
    private Set<Reference<ConstructModel>> constructs = new HashSet<Reference<ConstructModel>>();
    private Set<Reference<ConnectionProviderModel>> connectionProviders = new HashSet<Reference<ConnectionProviderModel>>();

    private <T> boolean isFirstAppearance(Set<Reference<T>> accumulator, T item) {
        return accumulator.add(new Reference<T>(item));
    }

    @Override
    protected final void onSource(HasSourceModels owner, SourceModel model) {
        this.doOnce(this.sources, model, this::onSource);
    }

    @Override
    protected void onParameterGroup(ParameterizedModel owner, ParameterGroupModel model) {
        this.doOnce(this.parameterGroups, model, group -> this.onParameterGroup(owner, (ParameterGroupModel)group));
    }

    @Override
    protected void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
        this.doOnce(this.parameters, model, p -> this.onParameter(groupModel, (ParameterModel)p));
    }

    @Override
    protected final void onOperation(HasOperationModels owner, OperationModel model) {
        this.doOnce(this.operations, model, this::onOperation);
    }

    @Override
    protected final void onFunction(HasFunctionModels owner, FunctionModel model) {
        this.doOnce(this.functions, model, this::onFunction);
    }

    @Override
    protected final void onConstruct(HasConstructModels owner, ConstructModel model) {
        this.doOnce(this.constructs, model, this::onConstruct);
    }

    @Override
    protected final void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
        this.doOnce(this.connectionProviders, model, this::onConnectionProvider);
    }

    private <T> void doOnce(Set<Reference<T>> accumulator, T item, Consumer<T> delegate) {
        if (this.isFirstAppearance(accumulator, item)) {
            delegate.accept(item);
        }
    }

    protected void onConnectionProvider(ConnectionProviderModel model) {
    }

    protected void onSource(SourceModel model) {
    }

    protected void onConstruct(ConstructModel model) {
    }

    protected void onParameter(ParameterGroupModel groupModel, ParameterModel model) {
    }

    protected void onParameterGroup(ParameterGroupModel model) {
    }

    protected void onOperation(OperationModel model) {
    }

    protected void onFunction(FunctionModel model) {
    }
}

