/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;

public abstract class AbstractComponent
implements Component {
    public static QName LOCATION_KEY = new QName("mule", "COMPONENT_LOCATION");
    public static QName ROOT_CONTAINER_NAME_KEY = new QName("mule", "ROOT_CONTAINER_NAME");
    private volatile Map<QName, Object> annotations = Collections.emptyMap();
    private final Object rootContainerLocationInitLock = new Object();
    private volatile Location rootContainerLocation;

    @Override
    public Object getAnnotation(QName qName) {
        return this.annotations.get(qName);
    }

    @Override
    public Map<QName, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    @Override
    public void setAnnotations(Map<QName, Object> newAnnotations) {
        this.annotations = new HashMap<QName, Object>(newAnnotations);
    }

    @Override
    public ComponentLocation getLocation() {
        return (ComponentLocation)this.getAnnotation(LOCATION_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Location getRootContainerLocation() {
        if (this.rootContainerLocation == null) {
            Object object = this.rootContainerLocationInitLock;
            synchronized (object) {
                if (this.rootContainerLocation == null) {
                    String rootContainerName = (String)this.getAnnotation(ROOT_CONTAINER_NAME_KEY);
                    if (rootContainerName == null) {
                        rootContainerName = this.getLocation().getRootContainerName();
                    }
                    this.rootContainerLocation = Location.builder().globalName(rootContainerName).build();
                }
            }
        }
        return this.rootContainerLocation;
    }
}

