/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.security;

import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.api.security.ServerSecurityException;

public class UnauthorisedException
extends ServerSecurityException {
    private static final long serialVersionUID = -6664384216189042673L;

    public UnauthorisedException(I18nMessage message) {
        super(message);
    }

    public UnauthorisedException(I18nMessage message, Throwable cause) {
        super(message, cause);
    }

    public UnauthorisedException(SecurityContext context, String filter, String connector) {
        super(UnauthorisedException.constructMessage(context, connector, filter));
    }

    private static I18nMessage constructMessage(SecurityContext context, String originatingConnectorName, String filter) {
        I18nMessage m = context == null ? I18nMessageFactory.createStaticMessage("Registered authentication is set to %s but there was no security context on the session", filter) : I18nMessageFactory.createStaticMessage("Authentication failed for principal %s", context.getAuthentication().getPrincipal());
        m.setNextMessage(I18nMessageFactory.createStaticMessage("Authentication denied on connector %s", originatingConnectorName));
        return m;
    }
}

