/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.deployment.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModelBuilder;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.util.Preconditions;

@NoExtend
public abstract class MuleDeployableModel
extends AbstractMuleArtifactModel {
    private final Set<String> configs;
    private final List<String> secureProperties;
    private Boolean redeploymentEnabled = true;

    protected MuleDeployableModel(String name, String minMuleVersion, Product product, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, MuleArtifactLoaderDescriptor bundleDescriptorLoader, Set<String> configs, Optional<Boolean> redeploymentEnabled, List<String> secureProperties) {
        super(name, minMuleVersion, product, classLoaderModelLoaderDescriptor, bundleDescriptorLoader);
        this.configs = configs;
        this.redeploymentEnabled = redeploymentEnabled.orElse(true);
        this.secureProperties = secureProperties;
    }

    public Set<String> getConfigs() {
        return this.configs == null ? null : Collections.unmodifiableSet(this.configs);
    }

    public boolean isRedeploymentEnabled() {
        return this.redeploymentEnabled == null ? true : this.redeploymentEnabled;
    }

    public List<String> getSecureProperties() {
        return this.secureProperties;
    }

    protected static abstract class MuleDeployableModelBuilder<T extends AbstractMuleArtifactModelBuilder, M extends MuleDeployableModel>
    extends AbstractMuleArtifactModelBuilder<T, M> {
        private Set<String> configs = new HashSet<String>();
        private Boolean redeploymentEnabled;
        private List<String> secureProperties = new ArrayList<String>();

        protected MuleDeployableModelBuilder() {
        }

        public void setConfigs(Set<String> configs) {
            this.configs = configs;
        }

        @Override
        public final M build() {
            Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)this.getName()), "name cannot be a blank");
            Preconditions.checkArgument(this.getMinMuleVersion() != null, "minMuleVersion cannot be null");
            Preconditions.checkArgument(this.getBundleDescriptorLoader() != null, "bundleDescriber cannot be null");
            return this.doCreateModel(this.configs, this.redeploymentEnabled, this.secureProperties);
        }

        protected abstract M doCreateModel(Set<String> var1, Boolean var2, List<String> var3);

        public void setRedeploymentEnabled(boolean redeploymentEnabled) {
            this.redeploymentEnabled = redeploymentEnabled;
        }

        public void setSecureProperties(List<String> secureProperties) {
            this.secureProperties = secureProperties;
        }
    }
}

