/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata.descriptor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;

public final class InputMetadataDescriptor {
    private final Map<String, ParameterMetadataDescriptor> parameters;

    private InputMetadataDescriptor(Map<String, ParameterMetadataDescriptor> parameters) {
        this.parameters = parameters;
    }

    public static InputMetadataDescriptorBuilder builder() {
        return new InputMetadataDescriptorBuilder();
    }

    public ParameterMetadataDescriptor getParameterMetadata(String paramName) {
        ParameterMetadataDescriptor result = this.parameters.get(paramName);
        if (result == null) {
            throw new IllegalArgumentException(String.format("The parameter [%s] does not belong to the described component", paramName));
        }
        return result;
    }

    public Map<String, ParameterMetadataDescriptor> getAllParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public static class InputMetadataDescriptorBuilder {
        private Map<String, ParameterMetadataDescriptor> parameters = new HashMap<String, ParameterMetadataDescriptor>();

        private InputMetadataDescriptorBuilder() {
        }

        public InputMetadataDescriptorBuilder withParameter(String name, ParameterMetadataDescriptor parameterResult) {
            if (parameterResult == null) {
                throw new IllegalArgumentException("A null ParameterMetadataDescriptor is not valid for the InputMetadataDescriptor");
            }
            this.parameters.put(name, parameterResult);
            return this;
        }

        public InputMetadataDescriptor build() {
            return new InputMetadataDescriptor(this.parameters);
        }
    }
}

