/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.api.annotation.NoExtend;
import org.mule.metadata.internal.utils.StringUtils;
import org.mule.runtime.api.metadata.DefaultMetadataKey;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataProperty;

@NoExtend
public class MetadataKeyBuilder {
    private final Set<MetadataProperty> properties = new HashSet<MetadataProperty>();
    private final String id;
    private String displayName;
    private Set<MetadataKey> childs = new LinkedHashSet<MetadataKey>();
    private Set<MetadataKeyBuilder> unbuiltChilds = new LinkedHashSet<MetadataKeyBuilder>();
    private String partName = "";

    protected MetadataKeyBuilder(String id) {
        this.id = id;
    }

    public static MetadataKeyBuilder newKey(String id) {
        return new MetadataKeyBuilder(id);
    }

    public MetadataKeyBuilder withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public MetadataKeyBuilder withProperty(MetadataProperty property) {
        if (this.properties.stream().anyMatch(p -> p.getClass().equals(property.getClass()))) {
            throw new IllegalArgumentException(String.format("The key %s already contains a metadata property of type %s", this.id, property.getClass().getName()));
        }
        this.properties.add(property);
        return this;
    }

    public MetadataKeyBuilder withChild(MetadataKeyBuilder metadataKeyBuilder) {
        this.unbuiltChilds.add(metadataKeyBuilder);
        return this;
    }

    public MetadataKeyBuilder withChild(MetadataKey metadataKey) {
        this.childs.add(metadataKey);
        return this;
    }

    public MetadataKeyBuilder withPartName(String partName) {
        this.setPartName(partName);
        return this;
    }

    protected void setPartName(String partName) {
        this.partName = partName;
    }

    public MetadataKey build() {
        String name = StringUtils.isNotEmpty((String)this.displayName) ? this.displayName : this.id;
        this.childs.addAll(this.unbuiltChilds.stream().map(MetadataKeyBuilder::build).collect(Collectors.toSet()));
        return new DefaultMetadataKey(this.id, name, this.properties, this.childs, this.partName);
    }
}

