/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.dsl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.type.TypeCatalog;

public final class DefaultDslResolvingContext
implements DslResolvingContext {
    private final TypeCatalog typeCatalog;
    private final Set<ExtensionModel> extensions;
    private final Map<String, ExtensionModel> extensionsByName;

    public DefaultDslResolvingContext(Set<ExtensionModel> extensions) {
        this.extensions = extensions;
        this.extensionsByName = extensions.stream().collect(Collectors.toMap(ExtensionModel::getName, e -> e, (u, v) -> v, LinkedHashMap::new));
        this.typeCatalog = TypeCatalog.getDefault(extensions);
    }

    @Override
    public Optional<ExtensionModel> getExtension(String name) {
        return Optional.ofNullable(this.extensionsByName.get(name));
    }

    @Override
    public Optional<ExtensionModel> getExtensionForType(String typeId) {
        return this.typeCatalog.getDeclaringExtension(typeId).map(this.extensionsByName::get);
    }

    @Override
    public Set<ExtensionModel> getExtensions() {
        return Collections.unmodifiableSet(this.extensions);
    }

    @Override
    public TypeCatalog getTypeCatalog() {
        return this.typeCatalog;
    }
}

