/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.display;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class PathModel {
    private final Type type;
    private final List<String> fileExtensions;
    private final boolean acceptsUrls;
    private final Location location;

    public PathModel(Type type, boolean acceptsUrls, Location location, String[] fileExtensions) {
        this.type = type;
        this.acceptsUrls = acceptsUrls;
        this.location = location;
        this.fileExtensions = Collections.unmodifiableList(Arrays.asList(fileExtensions));
    }

    public List<String> getFileExtensions() {
        return this.type == Type.DIRECTORY ? Collections.emptyList() : this.fileExtensions;
    }

    public Type getType() {
        return this.type;
    }

    public boolean acceptsUrls() {
        return this.acceptsUrls;
    }

    public Location getLocation() {
        return this.location;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)obj, (Object)this, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public static enum Type {
        DIRECTORY,
        FILE,
        ANY;

    }

    public static enum Location {
        EMBEDDED,
        EXTERNAL,
        ANY;

    }
}

