/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import java.util.ServiceLoader;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataTypeBuilderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataTypeBuilderFactory.class);
    private static final AbstractDataTypeBuilderFactory DEFAULT_FACTORY;

    static final AbstractDataTypeBuilderFactory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    protected abstract DataTypeBuilder create();

    protected abstract DataTypeBuilder create(DataType var1);

    static {
        try {
            AbstractDataTypeBuilderFactory factory = ServiceLoader.load(AbstractDataTypeBuilderFactory.class).iterator().next();
            LOGGER.debug(String.format("Loaded AbstractDataTypeBuilderFactory implementation '%s' from classloader '%s'", factory.getClass().getName(), factory.getClass().getClassLoader().toString()));
            DEFAULT_FACTORY = factory;
        }
        catch (Throwable t) {
            LOGGER.error("Error loading AbstractDataTypeBuilderFactory implementation.", t);
            throw t;
        }
    }
}

