/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.declaration.fluent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.model.declaration.fluent.NestableElementDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithNestedComponentsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithParametersDeclaration;
import org.mule.runtime.api.util.Preconditions;

public class NestedRouteDeclaration
extends NestableElementDeclaration<NestedRouteDeclaration>
implements WithParametersDeclaration,
WithNestedComponentsDeclaration<NestedRouteDeclaration> {
    private int minOccurs = 0;
    private Integer maxOccurs;
    private final List<NestableElementDeclaration> nestedComponents = new LinkedList<NestableElementDeclaration>();
    private final Map<String, ParameterGroupDeclaration> parameterGroups = new LinkedHashMap<String, ParameterGroupDeclaration>();

    NestedRouteDeclaration(String name) {
        super(name);
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
        super.setRequired(minOccurs > 0);
    }

    public Integer getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(Integer maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
        if (!required) {
            this.minOccurs = 0;
        }
    }

    @Override
    public List<ParameterGroupDeclaration> getParameterGroups() {
        return Collections.unmodifiableList(new ArrayList<ParameterGroupDeclaration>(this.parameterGroups.values()));
    }

    @Override
    public ParameterGroupDeclaration getParameterGroup(String groupName) {
        Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)groupName), "groupName cannot be blank");
        return this.parameterGroups.computeIfAbsent(groupName, ParameterGroupDeclaration::new);
    }

    @Override
    public List<ParameterDeclaration> getAllParameters() {
        return this.parameterGroups.values().stream().flatMap(g -> g.getParameters().stream()).collect(Collectors.toList());
    }

    @Override
    public List<NestableElementDeclaration> getNestedComponents() {
        return this.nestedComponents;
    }

    @Override
    public NestedRouteDeclaration addNestedComponent(NestableElementDeclaration nestedComponentDeclaration) {
        this.nestedComponents.add(nestedComponentDeclaration);
        return this;
    }
}

