/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.app.declaration.serialization.adapter;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.mule.runtime.api.app.declaration.ComponentElementDeclaration;
import org.mule.runtime.api.app.declaration.FlowElementDeclaration;
import org.mule.runtime.api.app.declaration.OperationElementDeclaration;
import org.mule.runtime.api.app.declaration.RouteElementDeclaration;
import org.mule.runtime.api.app.declaration.RouterElementDeclaration;
import org.mule.runtime.api.app.declaration.ScopeElementDeclaration;
import org.mule.runtime.api.app.declaration.SourceElementDeclaration;
import org.mule.runtime.api.app.declaration.fluent.BaseElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ComponentElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.RouterElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ScopeElementDeclarer;
import org.mule.runtime.internal.app.declaration.serialization.adapter.ElementDeclarationSerializationUtils;

class ComponentElementDeclarationTypeAdapter
extends TypeAdapter<ComponentElementDeclaration> {
    private final Gson delegate;

    ComponentElementDeclarationTypeAdapter(Gson delegate) {
        this.delegate = delegate;
    }

    public void write(JsonWriter out, ComponentElementDeclaration value) throws IOException {
        out.beginObject();
        ElementDeclarationSerializationUtils.populateParameterizedObject(this.delegate, out, value, this.getKind(value));
        if (value.getConfigRef() != null && !value.getConfigRef().trim().isEmpty()) {
            out.name("configRef").value(value.getConfigRef());
        }
        if (value instanceof RouterElementDeclaration) {
            out.name("routes").beginArray();
            ((RouterElementDeclaration)value).getRoutes().forEach(r -> this.delegate.toJson(r, RouteElementDeclaration.class, out));
            out.endArray();
        } else if (value instanceof ScopeElementDeclaration) {
            out.name("components").jsonValue(this.delegate.toJson(((ScopeElementDeclaration)value).getComponents()));
        }
        out.endObject();
    }

    public ComponentElementDeclaration read(JsonReader in) throws IOException {
        JsonElement parse = new JsonParser().parse(in);
        if (parse.isJsonObject()) {
            JsonObject jsonObject = parse.getAsJsonObject();
            JsonElement elementKind = jsonObject.get("kind");
            JsonElement elementExtension = jsonObject.get("declaringExtension");
            JsonElement elementName = jsonObject.get("name");
            if (elementKind != null && elementExtension != null && elementName != null) {
                Object declarer = this.getDeclarer(ElementDeclarer.forExtension(elementExtension.getAsString()), elementKind.getAsString(), elementName.getAsString());
                ElementDeclarationSerializationUtils.declareParameterizedElement(this.delegate, jsonObject, declarer);
                JsonElement configRef = jsonObject.get("configRef");
                if (configRef != null) {
                    ((ComponentElementDeclarer)declarer).withConfig(configRef.getAsString());
                }
                if (elementKind.getAsString().equals("ROUTER")) {
                    this.declareRouter(jsonObject, (RouterElementDeclarer)declarer);
                } else if (elementKind.getAsString().equals("SCOPE")) {
                    this.declareScope(jsonObject, (ComponentElementDeclarer)declarer);
                }
                return (ComponentElementDeclaration)((BaseElementDeclarer)declarer).getDeclaration();
            }
        }
        return null;
    }

    private void declareRouter(JsonObject jsonObject, RouterElementDeclarer declarer) {
        JsonElement routes = jsonObject.get("routes");
        if (routes != null && routes.isJsonArray()) {
            routes.getAsJsonArray().forEach(route -> declarer.withRoute((RouteElementDeclaration)this.delegate.fromJson(route, RouteElementDeclaration.class)));
        }
    }

    private void declareScope(JsonObject jsonObject, ComponentElementDeclarer declarer) {
        if (jsonObject.get("components") != null) {
            JsonArray components = jsonObject.get("components").getAsJsonArray();
            components.forEach(c -> ((ScopeElementDeclarer)declarer).withComponent((ComponentElementDeclaration)this.delegate.fromJson(c, ComponentElementDeclaration.class)));
        }
    }

    private <T extends ComponentElementDeclarer> T getDeclarer(ElementDeclarer declarer, String kind, String name) {
        switch (kind) {
            case "OPERATION": {
                return (T)declarer.newOperation(name);
            }
            case "SOURCE": {
                return (T)declarer.newSource(name);
            }
            case "SCOPE": {
                return (T)declarer.newScope(name);
            }
            case "ROUTER": {
                return (T)declarer.newRouter(name);
            }
        }
        throw new IllegalArgumentException("Unknown kind: " + kind);
    }

    private String getKind(ComponentElementDeclaration type) {
        if (type instanceof OperationElementDeclaration) {
            return "OPERATION";
        }
        if (type instanceof SourceElementDeclaration) {
            return "SOURCE";
        }
        if (type instanceof RouterElementDeclaration) {
            return "ROUTER";
        }
        if (type instanceof FlowElementDeclaration) {
            return "FLOW";
        }
        if (type instanceof ScopeElementDeclaration) {
            return "SCOPE";
        }
        throw new IllegalArgumentException("Unknown kind for type: " + type.getName());
    }
}

