/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.tls;

import java.util.ServiceLoader;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTlsContextFactoryBuilderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTlsContextFactoryBuilderFactory.class);
    private static final AbstractTlsContextFactoryBuilderFactory DEFAULT_FACTORY;

    static final AbstractTlsContextFactoryBuilderFactory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    protected abstract TlsContextFactoryBuilder create();

    static {
        try {
            AbstractTlsContextFactoryBuilderFactory factory = ServiceLoader.load(AbstractTlsContextFactoryBuilderFactory.class).iterator().next();
            LOGGER.info(String.format("Loaded TlsContextFactoryBuilderFactory implementation '%s' form classloader '%s'", factory.getClass().getName(), factory.getClass().getClassLoader().toString()));
            DEFAULT_FACTORY = factory;
        }
        catch (Throwable t) {
            LOGGER.error("Error loading TlsContextFactoryBuilderFactory implementation. Seems there's none in the classpath.", t);
            throw t;
        }
    }
}

