/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.app.declaration;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.app.declaration.ComponentElementDeclaration;
import org.mule.runtime.api.app.declaration.ElementDeclaration;
import org.mule.runtime.api.app.declaration.RouteElementDeclaration;

public final class RouterElementDeclaration
extends ComponentElementDeclaration {
    private List<RouteElementDeclaration> routes = new LinkedList<RouteElementDeclaration>();

    public RouterElementDeclaration() {
    }

    public RouterElementDeclaration(String extension, String name) {
        this.setDeclaringExtension(extension);
        this.setName(name);
    }

    public List<RouteElementDeclaration> getRoutes() {
        return this.routes;
    }

    public void addRoute(RouteElementDeclaration route) {
        this.routes.add(route);
    }

    @Override
    public <T extends ElementDeclaration> Optional<T> findElement(List<String> parts) {
        if (parts.isEmpty()) {
            return Optional.of(this);
        }
        if (this.routes.isEmpty()) {
            return Optional.empty();
        }
        String identifier = parts.get(0);
        if (StringUtils.isNumeric((CharSequence)identifier) && Integer.parseInt(identifier) < this.routes.size()) {
            return this.routes.get(Integer.parseInt(identifier)).findElement(parts.subList(1, parts.size()));
        }
        return super.findElement(parts);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RouterElementDeclaration) || !super.equals(o)) {
            return false;
        }
        RouterElementDeclaration that = (RouterElementDeclaration)o;
        return this.routes != null ? this.routes.equals(that.routes) : that.routes == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.routes != null ? this.routes.hashCode() : 0);
        return result;
    }
}

