/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.app.declaration.fluent;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.app.declaration.ParameterValue;
import org.mule.runtime.api.app.declaration.ParameterValueVisitor;
import org.mule.runtime.api.app.declaration.fluent.ParameterSimpleValue;

public final class ParameterListValue
implements ParameterValue {
    private List<ParameterValue> values = new LinkedList<ParameterValue>();

    ParameterListValue() {
    }

    public List<ParameterValue> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public void setValues(List<ParameterValue> values) {
        this.values = values;
    }

    @Override
    public void accept(ParameterValueVisitor valueVisitor) {
        valueVisitor.visitListValue(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterListValue that = (ParameterListValue)o;
        return this.values.equals(that.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public static class Builder {
        private ParameterListValue listValue = new ParameterListValue();

        private Builder() {
        }

        public Builder withValue(String value) {
            this.listValue.values.add(ParameterSimpleValue.of(value));
            return this;
        }

        public Builder withValue(ParameterValue value) {
            this.listValue.values.add(value);
            return this;
        }

        public ParameterListValue build() {
            return this.listValue;
        }
    }
}

