/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.exception;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.exception.DefaultExceptionReader;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleExceptionReader;
import org.mule.runtime.api.exception.NamingExceptionReader;
import org.mule.runtime.api.legacy.exception.ExceptionReader;

public class ExceptionHelper {
    private static final String MULE_PACKAGE_REGEXP = "(?:org|com)\\.mule(?:soft)?\\.(?!mvel2)(?!el).*";
    public static final String[] DEFAULT_STACKTRACE_FILTER = "org.mule.runtime.core.processor.AbstractInterceptingMessageProcessor,org.mule.runtime.core.processor.chain".split(",");
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int EXCEPTION_THRESHOLD = 3;
    private static boolean verbose = true;
    private static boolean initialised = false;
    private static List<ExceptionReader> exceptionReaders = new ArrayList<ExceptionReader>();
    private static ExceptionReader defaultExceptionReader = new DefaultExceptionReader();
    public static String[] stackTraceFilter = DEFAULT_STACKTRACE_FILTER;
    public static boolean fullStackTraces = false;

    protected ExceptionHelper() {
    }

    public static <T extends Throwable> T unwrap(T t) {
        if (t instanceof InvocationTargetException) {
            return (T)((InvocationTargetException)t).getTargetException();
        }
        return t;
    }

    public static ExceptionReader getExceptionReader(Throwable t) {
        for (ExceptionReader exceptionReader : exceptionReaders) {
            if (!exceptionReader.getExceptionType().isInstance(t)) continue;
            return exceptionReader;
        }
        return defaultExceptionReader;
    }

    public static MuleException getRootMuleException(Throwable t) {
        Throwable cause = t;
        MuleException exception = null;
        HashMap muleExceptionInfo = new HashMap();
        while (cause != null) {
            if (cause instanceof MuleException) {
                exception = (MuleException)cause;
                muleExceptionInfo.putAll(exception.getInfo());
            }
            Throwable tempCause = ExceptionHelper.getExceptionReader(cause).getCause(cause);
            cause = fullStackTraces ? tempCause : ExceptionHelper.sanitize(tempCause);
            if (t != cause) continue;
            break;
        }
        if (exception != null) {
            exception.getInfo().putAll(muleExceptionInfo);
        }
        return exception;
    }

    public static Throwable getNonMuleException(Throwable t) {
        if (!(t instanceof MuleException)) {
            return t;
        }
        Throwable cause = t;
        while (cause != null && t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause)) && cause instanceof MuleException) {
        }
        return cause instanceof MuleException ? null : cause;
    }

    public static Map getExceptionInfo(Throwable t) {
        HashMap info = new HashMap();
        Throwable cause = t;
        while (cause != null) {
            info.putAll(ExceptionHelper.getExceptionReader(cause).getInfo(cause));
            if (t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
            break;
        }
        return info;
    }

    public static Throwable getRootException(Throwable t) {
        Throwable cause = t;
        Throwable root = null;
        while (cause != null) {
            root = cause;
            if (t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
        }
        return fullStackTraces ? root : ExceptionHelper.sanitize(root);
    }

    public static String getExceptionStack(Throwable t) {
        Throwable root = ExceptionHelper.getRootException(t);
        MuleException rootMule = ExceptionHelper.getRootMuleException(t);
        StringBuilder buf = new StringBuilder();
        ExceptionReader rootMuleReader = ExceptionHelper.getExceptionReader(rootMule);
        buf.append(rootMuleReader.getMessage(rootMule)).append(" (").append(rootMule.getClass().getName()).append(")").append(LINE_SEPARATOR);
        if (verbose) {
            int processedElements = 0;
            int processedMuleElements = 1;
            for (StackTraceElement stackTraceElement : root.getStackTrace()) {
                if (processedMuleElements > 3) break;
                ++processedElements;
                if (stackTraceElement.getClassName().matches(MULE_PACKAGE_REGEXP)) {
                    ++processedMuleElements;
                }
                buf.append("  ").append(stackTraceElement.getClassName()).append(".").append(stackTraceElement.getMethodName()).append("(").append(stackTraceElement.getFileName()).append(":").append(stackTraceElement.getLineNumber()).append(")").append(LINE_SEPARATOR);
            }
            if (root.getStackTrace().length - processedElements > 0) {
                buf.append("  (").append(root.getStackTrace().length - processedElements).append(" more...)").append(LINE_SEPARATOR);
            }
        }
        return buf.toString();
    }

    private static void initialise() {
        String stackTraceFilterString;
        if (initialised) {
            return;
        }
        String fullStackTracesString = System.getProperty("mule.stacktrace.full");
        if (fullStackTracesString != null) {
            fullStackTraces = false;
        }
        if ((stackTraceFilterString = System.getProperty("mule.stacktrace.filter")) != null) {
            stackTraceFilter = stackTraceFilterString.split(",");
        }
        ExceptionHelper.registerExceptionReader(new MuleExceptionReader());
        ExceptionHelper.registerExceptionReader(new NamingExceptionReader());
        initialised = true;
    }

    public static Throwable sanitize(Throwable t) {
        if (t == null) {
            return null;
        }
        StackTraceElement[] trace = t.getStackTrace();
        ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
        for (StackTraceElement stackTraceElement : trace) {
            if (ExceptionHelper.isMuleInternalClass(stackTraceElement.getClassName())) continue;
            newTrace.add(stackTraceElement);
        }
        StackTraceElement[] clean = new StackTraceElement[newTrace.size()];
        newTrace.toArray(clean);
        t.setStackTrace(clean);
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            ExceptionHelper.sanitize(cause);
        }
        return t;
    }

    public static Throwable summarise(Throwable t, int depth) {
        t = ExceptionHelper.sanitize(t);
        StackTraceElement[] trace = t.getStackTrace();
        int newStackDepth = Math.min(trace.length, depth);
        StackTraceElement[] newTrace = new StackTraceElement[newStackDepth];
        System.arraycopy(trace, 0, newTrace, 0, newStackDepth);
        t.setStackTrace(newTrace);
        return t;
    }

    private static boolean isMuleInternalClass(String className) {
        for (String mulePackage : stackTraceFilter) {
            if (!className.startsWith(mulePackage)) continue;
            return true;
        }
        return false;
    }

    public static List<Throwable> getExceptionsAsList(Throwable t) {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        Throwable cause = t;
        while (cause != null) {
            exceptions.add(0, cause);
            if (t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
            break;
        }
        return exceptions;
    }

    public static void registerExceptionReader(ExceptionReader reader) {
        exceptionReaders.add(reader);
    }

    static {
        ExceptionHelper.initialise();
    }
}

