/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.DependencyNode;

public class MulePluginDependencyGraphTransformer
implements DependencyGraphTransformer {
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        IdentityHashMap<DependencyNode, Object> visitedNodes = new IdentityHashMap<DependencyNode, Object>(512);
        this.visitGraph(node, visitedNodes, true);
        return node;
    }

    private void visitGraph(DependencyNode node, Map<DependencyNode, Object> visitedNodes, boolean rootNode) throws RepositoryException {
        if (!this.setVisited(node, visitedNodes)) {
            return;
        }
        if (this.isPlugin(node) && !rootNode) {
            while (!this.hasOnlyPluginDependencies(node)) {
                this.removeNormalDependencies(node);
            }
        }
        for (DependencyNode child : node.getChildren()) {
            this.visitGraph(child, visitedNodes, false);
        }
    }

    private boolean setVisited(DependencyNode node, Map<DependencyNode, Object> visitedNodes) {
        return visitedNodes.put(node, Boolean.TRUE) == null;
    }

    private boolean hasOnlyPluginDependencies(DependencyNode node) {
        return node.getChildren().isEmpty() || node.getChildren().stream().allMatch(this::isPlugin);
    }

    private void removeNormalDependencies(DependencyNode node) {
        node.setChildren(node.getChildren().stream().flatMap(childNode -> {
            if (this.isPlugin((DependencyNode)childNode)) {
                return Arrays.asList(childNode).stream();
            }
            return childNode.getChildren().stream().filter(n -> this.haveDifferentGroupAndArtifactIds((DependencyNode)childNode, (DependencyNode)n));
        }).collect(Collectors.toList()));
    }

    private boolean haveDifferentGroupAndArtifactIds(DependencyNode a, DependencyNode b) {
        return !a.getArtifact().getGroupId().equals(b.getArtifact().getGroupId()) || !a.getArtifact().getArtifactId().equals(b.getArtifact().getArtifactId());
    }

    private boolean isPlugin(DependencyNode node) {
        return node != null && node.getArtifact() != null && "mule-plugin".equals(node.getArtifact().getClassifier());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return null != obj && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

