/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal.util;

public class VersionChecker {
    public static boolean areCompatibleVersions(String version1, String version2) {
        String[] version1Parts = VersionChecker.getVersionParts(version1);
        String[] version2Parts = VersionChecker.getVersionParts(version2);
        return version1Parts[0].equals(version2Parts[0]);
    }

    private static String[] getVersionParts(String version1) {
        String[] version1Parts = version1.split("\\.");
        if (version1Parts.length < 1) {
            throw new RuntimeException("Cannot compare version using version " + version1);
        }
        return version1Parts;
    }

    public static String getHighestVersion(String version1, String version2) {
        String[] versionParts1 = VersionChecker.getVersionParts(version1);
        String[] versionParts2 = VersionChecker.getVersionParts(version2);
        for (int i = 0; i < versionParts1.length; ++i) {
            if (versionParts2.length < i) {
                return version1;
            }
            Integer compareResult = i < 2 ? Integer.valueOf(VersionChecker.convertVersionPartToInt(versionParts1[i], version1).compareTo(VersionChecker.convertVersionPartToInt(versionParts2[i], version2))) : Integer.valueOf(versionParts1[i].compareTo(versionParts2[i]));
            if (compareResult < 0) {
                return version2;
            }
            if (compareResult <= 0) continue;
            return version1;
        }
        return version2;
    }

    private static Integer convertVersionPartToInt(String part, String version) {
        try {
            return Integer.parseInt(part);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(String.format("Could not parse part %s to integer, version %s is not following semantic versioning", part, version));
        }
    }
}

