/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.mule.maven.client.api.BadMavenConfigurationException;
import org.mule.maven.client.api.model.Authentication;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.maven.client.internal.RemoteRepositoriesMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherResolutionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(AetherMavenClient.class);
    private List<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
    private File localRepositoryLocation;
    private Optional<AuthenticationSelector> authenticationSelector = Optional.empty();

    public AetherResolutionContext(MavenConfiguration mavenConfiguration) {
        this.resolveMavenConfiguration(mavenConfiguration);
    }

    public File getLocalRepositoryLocation() {
        return this.localRepositoryLocation;
    }

    public List<RemoteRepository> getRemoteRepositories() {
        return Lists.newArrayList(this.remoteRepositories);
    }

    private void resolveMavenConfiguration(MavenConfiguration mavenConfiguration) {
        this.localRepositoryLocation = mavenConfiguration.getLocalMavenRepositoryLocation();
        Optional<Settings> mavenSettingsOptional = this.getMavenSettings(mavenConfiguration.getUserSettingsLocation(), mavenConfiguration.getGlobalSettingsLocation());
        this.remoteRepositories = this.collectRepositoriesFromConfiguration(mavenConfiguration, mavenSettingsOptional);
        mavenSettingsOptional.ifPresent(mavenSettings -> {
            this.createAuthenticatorSelector((Settings)mavenSettings);
            this.addRepositoriesFromMavenConfig(mavenConfiguration, (Settings)mavenSettings);
            String localRepository = mavenSettings.getLocalRepository();
            if (localRepository != null) {
                File localRepositoryFile = new File(localRepository);
                if (!localRepositoryFile.isDirectory() || !localRepositoryFile.exists()) {
                    throw new BadMavenConfigurationException(String.format("Local repository location %s resolved from maven settings file does not exists or is not a directory", localRepository));
                }
                this.localRepositoryLocation = localRepositoryFile;
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using {}", (Object)this.toString());
        }
    }

    private List<RemoteRepository> collectRepositoriesFromConfiguration(MavenConfiguration mavenConfiguration, Optional<Settings> mavenSettingsOptional) {
        ImmutableList.Builder collectedRepositories = ImmutableList.builder();
        List clientConfiguredRepositories = mavenConfiguration.getMavenRemoteRepositories();
        clientConfiguredRepositories.stream().forEachOrdered(remoteRepoConfig -> {
            RemoteRepository.Builder aetherRepoBuilder = new RemoteRepository.Builder(remoteRepoConfig.getId(), "default", remoteRepoConfig.getUrl().toString());
            if (remoteRepoConfig.getAuthentication().isPresent()) {
                Authentication authentication = (Authentication)remoteRepoConfig.getAuthentication().get();
                aetherRepoBuilder.setAuthentication(new AuthenticationBuilder().addUsername(authentication.getUsername()).addPassword(authentication.getPassword()).build());
            } else {
                mavenSettingsOptional.ifPresent(settings -> {
                    Server server = settings.getServer(remoteRepoConfig.getId());
                    if (server != null) {
                        aetherRepoBuilder.setAuthentication(new AuthenticationBuilder().addUsername(server.getUsername()).addPassword(server.getPassword()).addPrivateKey(server.getPrivateKey(), server.getPassphrase()).build());
                    }
                });
            }
            if (mavenConfiguration.getForcePolicyUpdateNever()) {
                aetherRepoBuilder.setSnapshotPolicy(new RepositoryPolicy(true, "never", "ignore"));
                aetherRepoBuilder.setReleasePolicy(new RepositoryPolicy(true, "never", "fail"));
            }
            collectedRepositories.add((Object)aetherRepoBuilder.build());
        });
        return collectedRepositories.build();
    }

    private void addRepositoriesFromMavenConfig(MavenConfiguration mavenConfiguration, Settings mavenSettings) {
        ImmutableList.Builder remoteRepositoriesFromSettings = ImmutableList.builder();
        for (String profileName : mavenSettings.getProfilesAsMap().keySet()) {
            Profile profile = (Profile)mavenSettings.getProfilesAsMap().get(profileName);
            if (!mavenSettings.getActiveProfiles().contains(profileName) && !Optional.ofNullable(profile.getActivation()).map(Activation::isActiveByDefault).orElse(true).booleanValue()) continue;
            List repositories = profile.getRepositories();
            for (Repository repo : repositories) {
                RemoteRepository.Builder remoteRepo = new RemoteRepository.Builder(repo.getId(), "default", repo.getUrl());
                if (mavenConfiguration.getForcePolicyUpdateNever()) {
                    remoteRepo.setSnapshotPolicy(new RepositoryPolicy(true, "never", "ignore"));
                    remoteRepo.setReleasePolicy(new RepositoryPolicy(true, "never", "fail"));
                } else {
                    if (repo.getSnapshots() != null) {
                        remoteRepo.setSnapshotPolicy(new RepositoryPolicy(repo.getSnapshots().isEnabled(), repo.getSnapshots().getUpdatePolicy(), repo.getSnapshots().getChecksumPolicy()));
                    }
                    if (repo.getReleases() != null) {
                        remoteRepo.setReleasePolicy(new RepositoryPolicy(repo.getReleases().isEnabled(), repo.getReleases().getUpdatePolicy(), repo.getReleases().getChecksumPolicy()));
                    }
                }
                Server server = mavenSettings.getServer(repo.getId());
                if (server != null) {
                    remoteRepo.setAuthentication(new AuthenticationBuilder().addPassword(server.getPassword()).addUsername(server.getUsername()).addPrivateKey(server.getPrivateKey(), server.getPassphrase()).build());
                }
                remoteRepositoriesFromSettings.add((Object)remoteRepo.build());
            }
        }
        this.remoteRepositories = new RemoteRepositoriesMerger().merge(this.remoteRepositories, (List<RemoteRepository>)remoteRepositoriesFromSettings.build());
    }

    private void createAuthenticatorSelector(Settings mavenSettings) {
        DefaultAuthenticationSelector defaultAuthenticationSelector = new DefaultAuthenticationSelector();
        mavenSettings.getServers().stream().forEach(server -> defaultAuthenticationSelector.add(server.getId(), new AuthenticationBuilder().addPassword(server.getPassword()).addUsername(server.getUsername()).addPrivateKey(server.getPrivateKey(), server.getPassphrase()).build()));
        this.authenticationSelector = Optional.of(defaultAuthenticationSelector);
    }

    private Optional<Settings> getMavenSettings(Optional<File> userSettingsFile, Optional<File> globalSettingsFile) {
        if (!userSettingsFile.isPresent() && !globalSettingsFile.isPresent()) {
            return Optional.empty();
        }
        try {
            DefaultSettingsBuildingRequest settingsBuildingRequest = new DefaultSettingsBuildingRequest();
            settingsBuildingRequest.setSystemProperties(System.getProperties());
            userSettingsFile.ifPresent(arg_0 -> ((SettingsBuildingRequest)settingsBuildingRequest).setUserSettingsFile(arg_0));
            globalSettingsFile.ifPresent(arg_0 -> ((SettingsBuildingRequest)settingsBuildingRequest).setGlobalSettingsFile(arg_0));
            DefaultSettingsBuilderFactory mvnSettingBuilderFactory = new DefaultSettingsBuilderFactory();
            DefaultSettingsBuilder settingsBuilder = mvnSettingBuilderFactory.newInstance();
            SettingsBuildingResult settingsBuildingResult = settingsBuilder.build((SettingsBuildingRequest)settingsBuildingRequest);
            return Optional.of(settingsBuildingResult.getEffectiveSettings());
        }
        catch (SettingsBuildingException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<AuthenticationSelector> getAuthenticatorSelector() {
        return this.authenticationSelector;
    }

    public String toString() {
        return "AetherResolutionContext{remoteRepositories=" + this.repositoriesToString() + ", localMavenRepositoryLocation=" + this.localRepositoryLocation.getAbsolutePath() + '}';
    }

    private String repositoriesToString() {
        return String.join((CharSequence)",\n", this.remoteRepositories.stream().map(RemoteRepository::toString).collect(Collectors.toList()));
    }
}

