/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.api.model;

import java.net.URI;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.BundleScope;
import org.mule.maven.client.api.util.Preconditions;

public class BundleDependency {
    private BundleDescriptor descriptor;
    private BundleScope scope;
    private URI bundleUri;

    private BundleDependency() {
    }

    public BundleScope getScope() {
        return this.scope;
    }

    public BundleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public URI getBundleUri() {
        return this.bundleUri;
    }

    public String toString() {
        return "BundleDependency{descriptor=" + this.descriptor + ", scope=" + (Object)((Object)this.scope) + ", bundleUrl=" + this.bundleUri + '}';
    }

    public static class Builder {
        private static final String BUNDLE_DESCRIPTOR = "bundle descriptor";
        private static final String REQUIRED_FIELD_NOT_FOUND_TEMPLATE = "bundle cannot be created with null or empty %s";
        private static final String REQUIRED_FIELD_IS_NULL = "bundle cannot be created with null %s";
        private BundleDependency bundleDependency = new BundleDependency();

        public Builder setDescriptor(BundleDescriptor descriptor) {
            this.validateIsNotNull(descriptor, BUNDLE_DESCRIPTOR);
            this.bundleDependency.descriptor = descriptor;
            return this;
        }

        public Builder setScope(BundleScope scope) {
            Preconditions.checkState(scope != null, "scope cannot be null");
            this.bundleDependency.scope = scope;
            return this;
        }

        public Builder sedBundleDescriptor(BundleDescriptor descriptor) {
            this.validateIsNotNull(descriptor, BUNDLE_DESCRIPTOR);
            this.bundleDependency.descriptor = descriptor;
            return this;
        }

        public Builder setBundleUri(URI bundleUri) {
            this.validateIsNotNull(bundleUri, "Bundle URI cannot be null");
            this.bundleDependency.bundleUri = bundleUri;
            return this;
        }

        public BundleDependency build() {
            this.validateIsNotNull(this.bundleDependency.descriptor, BUNDLE_DESCRIPTOR);
            return this.bundleDependency;
        }

        private String getEmptyFieldMessage(String field) {
            return String.format(REQUIRED_FIELD_NOT_FOUND_TEMPLATE, field);
        }

        private String getNullFieldMessage(String field) {
            return String.format(REQUIRED_FIELD_IS_NULL, field);
        }

        private void validateIsNotEmpty(String value, String fieldId) {
            Preconditions.checkState(!Builder.isEmpty(value), this.getEmptyFieldMessage(fieldId));
        }

        private static boolean isEmpty(String value) {
            return value == null || value.equals("");
        }

        private void validateIsNotNull(Object value, String fieldId) {
            Preconditions.checkState(value != null, this.getNullFieldMessage(fieldId));
        }
    }
}

