/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.queue.objectstore.xa;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.mule.runtime.core.util.queue.objectstore.xa.AbstractTransactionContext;
import org.mule.runtime.core.util.queue.objectstore.xa.AbstractXAResourceManager;
import org.mule.runtime.core.util.xa.ResourceManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DefaultXASession
implements XAResource {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected AbstractTransactionContext localContext = null;
    protected Xid localXid = null;
    protected AbstractXAResourceManager resourceManager;

    public DefaultXASession(AbstractXAResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public XAResource getXAResource() {
        return this;
    }

    public Object getResourceManager() {
        return this.resourceManager;
    }

    public void begin() throws ResourceManagerException {
        if (this.localXid != null) {
            throw new IllegalStateException("Cannot start local transaction. An XA transaction is already in progress.");
        }
        if (this.localContext != null) {
            throw new IllegalStateException("Cannot start local transaction. A local transaction already in progress.");
        }
        this.localContext = this.resourceManager.createTransactionContext(this);
        this.resourceManager.beginTransaction(this.localContext);
    }

    public void commit() throws ResourceManagerException {
        if (this.localXid != null) {
            throw new IllegalStateException("Cannot commit local transaction as an XA transaction is in progress.");
        }
        if (this.localContext == null) {
            throw new IllegalStateException("Cannot commit local transaction as no transaction was begun");
        }
        this.resourceManager.commitTransaction(this.localContext);
        this.localContext = null;
    }

    public void rollback() throws ResourceManagerException {
        if (this.localXid != null) {
            throw new IllegalStateException("Cannot rollback local transaction as an XA transaction is in progress.");
        }
        if (this.localContext == null) {
            throw new IllegalStateException("Cannot commit local transaction as no transaction was begun");
        }
        this.resourceManager.rollbackTransaction(this.localContext);
        this.localContext = null;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        return xares instanceof org.mule.runtime.core.util.xa.DefaultXASession && ((org.mule.runtime.core.util.xa.DefaultXASession)xares).getResourceManager().equals(this.resourceManager);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return null;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(new StringBuilder(128).append("Thread ").append(Thread.currentThread()).append(flags == 0 ? " starts" : (flags == 0x200000 ? " joins" : " resumes")).append(" work on behalf of transaction branch ").append(xid).toString());
        }
        if (this.localContext != null) {
            throw new XAException(-6);
        }
        if (this.localXid != null) {
            throw new XAException(-6);
        }
        switch (flags) {
            default: {
                try {
                    this.localContext = this.resourceManager.createTransactionContext(this);
                    this.resourceManager.beginTransaction(this.localContext);
                    break;
                }
                catch (Exception e) {
                    this.logger.error("Could not create new transactional resource", (Throwable)e);
                    throw (XAException)new XAException(e.getMessage()).initCause(e);
                }
            }
            case 0x8000000: {
                this.localContext = this.resourceManager.getSuspendedTransactionalResource(xid);
                if (this.localContext == null) {
                    throw new XAException(-4);
                }
                this.resourceManager.removeSuspendedTransactionalResource(xid);
            }
        }
        this.localXid = xid;
        this.resourceManager.addActiveTransactionalResource(this.localXid, this.localContext);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(new StringBuilder(128).append("Thread ").append(Thread.currentThread()).append(flags == 0x2000000 ? " suspends" : (flags == 0x20000000 ? " fails" : " ends")).append(" work on behalf of transaction branch ").append(xid).toString());
        }
        if (this.localContext == null) {
            throw new XAException(-4);
        }
        if (this.localXid == null || !this.localXid.equals(xid)) {
            throw new XAException(-6);
        }
        try {
            switch (flags) {
                case 0x2000000: {
                    this.resourceManager.addSuspendedTransactionalResource(this.localXid, this.localContext);
                    this.resourceManager.removeActiveTransactionalResource(this.localXid);
                    break;
                }
                case 0x20000000: {
                    this.resourceManager.setTransactionRollbackOnly(this.localContext);
                    break;
                }
            }
        }
        catch (ResourceManagerException e) {
            throw (XAException)new XAException(-3).initCause((Throwable)((Object)e));
        }
        this.localXid = null;
        this.localContext = null;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (xid == null) {
            throw new XAException(-6);
        }
        AbstractTransactionContext context = this.resourceManager.getActiveTransactionalResource(xid);
        if (context == null) {
            throw new XAException(-4);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Committing transaction branch " + xid);
        }
        if (context.status == 1) {
            throw new XAException(100);
        }
        try {
            if (context.status != 2) {
                if (onePhase) {
                    this.resourceManager.prepareTransaction(context);
                } else {
                    throw new XAException(-6);
                }
            }
            this.resourceManager.commitTransaction(context);
            this.localContext = null;
        }
        catch (ResourceManagerException e) {
            throw (XAException)new XAException(-3).initCause((Throwable)((Object)e));
        }
        this.resourceManager.removeActiveTransactionalResource(xid);
        this.resourceManager.removeSuspendedTransactionalResource(xid);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-6);
        }
        AbstractTransactionContext context = this.resourceManager.getActiveTransactionalResource(xid);
        if (context == null) {
            throw new XAException(-4);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Rolling back transaction branch " + xid);
        }
        try {
            this.resourceManager.rollbackTransaction(context);
            this.localContext = null;
        }
        catch (ResourceManagerException e) {
            throw (XAException)new XAException(-3).initCause((Throwable)((Object)e));
        }
        this.resourceManager.removeActiveTransactionalResource(xid);
        this.resourceManager.removeSuspendedTransactionalResource(xid);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-6);
        }
        AbstractTransactionContext context = this.resourceManager.getTransactionalResource(xid);
        if (context == null) {
            throw new XAException(-4);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Preparing transaction branch " + xid);
        }
        if (context.status == 1) {
            throw new XAException(100);
        }
        try {
            return this.resourceManager.prepareTransaction(context);
        }
        catch (ResourceManagerException e) {
            throw (XAException)new XAException(-3).initCause((Throwable)((Object)e));
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        AbstractTransactionContext context;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Forgetting transaction branch " + xid);
        }
        if ((context = this.resourceManager.getTransactionalResource(xid)) == null) {
            throw new XAException(-4);
        }
        this.resourceManager.removeActiveTransactionalResource(xid);
        this.resourceManager.removeSuspendedTransactionalResource(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return (int)(this.resourceManager.getDefaultTransactionTimeout() / 1000L);
    }

    @Override
    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.resourceManager.setDefaultTransactionTimeout(timeout * 1000);
        return false;
    }
}

