/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.queue.objectstore;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.core.api.store.ObjectStoreException;
import org.mule.runtime.core.util.queue.objectstore.QueueInfo;
import org.mule.runtime.core.util.queue.objectstore.TransactionalQueueManager;
import org.mule.runtime.core.util.queue.objectstore.xa.AbstractTransactionContext;
import org.mule.runtime.core.util.xa.ResourceManagerException;

@Deprecated
public class QueueTransactionContext
extends AbstractTransactionContext {
    private final TransactionalQueueManager transactionalQueueManager;
    private Map<QueueInfo, List<Serializable>> added;
    private Map<QueueInfo, List<Serializable>> removed;

    public QueueTransactionContext(TransactionalQueueManager transactionalQueueManager) {
        this.transactionalQueueManager = transactionalQueueManager;
    }

    public boolean offer(QueueInfo queue, Serializable item, long offerTimeout) throws InterruptedException, ObjectStoreException {
        this.readOnly = false;
        if (queue.canTakeFromStore()) {
            queue.writeToObjectStore(item);
            return true;
        }
        this.initializeAdded();
        List<Serializable> queueAdded = this.lookupAddedQueue(queue);
        if (queue.offer(null, queueAdded.size(), offerTimeout)) {
            queueAdded.add(item);
            return true;
        }
        return false;
    }

    public void untake(QueueInfo queue, Serializable item) throws InterruptedException, ObjectStoreException {
        this.readOnly = false;
        if (queue.canTakeFromStore()) {
            queue.writeToObjectStore(item);
        }
        this.initializeAdded();
        List<Serializable> queueAdded = this.lookupAddedQueue(queue);
        queueAdded.add(item);
    }

    public void clear(QueueInfo queue) throws InterruptedException {
        List<Serializable> queueAdded;
        this.readOnly = false;
        if (queue.canTakeFromStore()) {
            queue.clear();
        }
        this.initializeRemoved();
        List<Serializable> queueRemoved = this.lookupRemovedQueue(queue);
        Serializable discardedItem = queue.poll(this.timeout);
        while (discardedItem != null) {
            queueRemoved.add(discardedItem);
            discardedItem = queue.poll(this.timeout);
        }
        if (this.added != null && !CollectionUtils.isEmpty(queueAdded = this.lookupAddedQueue(queue))) {
            queueRemoved.addAll(queueAdded);
            queueAdded.clear();
        }
    }

    public Serializable poll(QueueInfo queue, long pollTimeout) throws InterruptedException, ObjectStoreException {
        Serializable key;
        List<Serializable> queueAdded;
        this.readOnly = false;
        if (this.added != null && (queueAdded = this.added.get(queue)) != null && queueAdded.size() > 0) {
            return queueAdded.remove(queueAdded.size() - 1);
        }
        if (queue.canTakeFromStore()) {
            return queue.takeNextItemFromStore(this.timeout);
        }
        Serializable value = null;
        try {
            key = queue.poll(pollTimeout);
        }
        catch (InterruptedException e) {
            if (!this.transactionalQueueManager.getMuleContext().isStopping()) {
                throw e;
            }
            return null;
        }
        if (key != null) {
            List<Serializable> queueRemoved;
            if (this.removed == null) {
                this.removed = new HashMap<QueueInfo, List<Serializable>>();
            }
            if ((queueRemoved = this.removed.get(queue)) == null) {
                queueRemoved = new ArrayList<Serializable>();
                this.removed.put(queue, queueRemoved);
            }
            if ((value = this.transactionalQueueManager.doLoad(queue, key)) != null) {
                queueRemoved.add(key);
            }
        }
        return value;
    }

    public Serializable peek(QueueInfo queue) throws InterruptedException, ObjectStoreException {
        List<Serializable> queueAdded;
        this.readOnly = false;
        if (this.added != null && (queueAdded = this.added.get(queue)) != null) {
            return queueAdded.get(queueAdded.size() - 1);
        }
        Serializable o = queue.peek();
        if (o != null) {
            o = this.transactionalQueueManager.doLoad(queue, o);
        }
        return o;
    }

    public int size(QueueInfo queue) {
        List<Serializable> queueAdded;
        int sz = queue.getSize();
        if (this.added != null && (queueAdded = this.added.get(queue)) != null) {
            sz += queueAdded.size();
        }
        return sz;
    }

    @Override
    public void doCommit() throws ResourceManagerException {
        try {
            QueueInfo queue;
            if (this.added != null) {
                for (Map.Entry<QueueInfo, List<Serializable>> entry : this.added.entrySet()) {
                    queue = entry.getKey();
                    List<Serializable> queueAdded = entry.getValue();
                    if (queueAdded == null || queueAdded.size() <= 0) continue;
                    for (Serializable object : queueAdded) {
                        Serializable id = this.transactionalQueueManager.doStore(queue, object);
                        queue.putNow(id);
                    }
                }
            }
            if (this.removed != null) {
                for (Map.Entry<QueueInfo, List<Serializable>> entry : this.removed.entrySet()) {
                    queue = entry.getKey();
                    List<Serializable> queueRemoved = entry.getValue();
                    if (queueRemoved == null || queueRemoved.size() <= 0) continue;
                    for (Serializable id : queueRemoved) {
                        this.transactionalQueueManager.doRemove(queue, id);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ResourceManagerException(e);
        }
        finally {
            this.added = null;
            this.removed = null;
        }
    }

    @Override
    public void doRollback() throws ResourceManagerException {
        if (this.removed != null) {
            for (Map.Entry<QueueInfo, List<Serializable>> entry : this.removed.entrySet()) {
                QueueInfo queue = entry.getKey();
                List<Serializable> queueRemoved = entry.getValue();
                if (queueRemoved == null || queueRemoved.size() <= 0) continue;
                for (Serializable id : queueRemoved) {
                    queue.putNow(id);
                }
            }
        }
        this.added = null;
        this.removed = null;
    }

    protected void initializeAdded() {
        if (this.added == null) {
            this.added = new HashMap<QueueInfo, List<Serializable>>();
        }
    }

    protected void initializeRemoved() {
        if (this.removed == null) {
            this.removed = new HashMap<QueueInfo, List<Serializable>>();
        }
    }

    protected List<Serializable> lookupAddedQueue(QueueInfo queue) {
        List<Serializable> queueAdded = this.added.get(queue);
        if (queueAdded == null) {
            queueAdded = new ArrayList<Serializable>();
            this.added.put(queue, queueAdded);
        }
        return queueAdded;
    }

    protected List<Serializable> lookupRemovedQueue(QueueInfo queue) {
        List<Serializable> queueRemoved = this.removed.get(queue);
        if (queueRemoved == null) {
            queueRemoved = new ArrayList<Serializable>();
            this.removed.put(queue, queueRemoved);
        }
        return queueRemoved;
    }
}

