/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.message;

import java.util.ListIterator;
import java.util.function.Consumer;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.util.message.MessageUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;

final class ResultToMessageListIterator
implements ListIterator<Message> {
    private final ListIterator<Result> delegate;
    private final MediaType mediaType;
    private final CursorStreamProviderFactory cursorStreamProviderFactory;
    private final Event event;

    ResultToMessageListIterator(ListIterator<Result> delegate, MediaType mediaType, CursorStreamProviderFactory cursorStreamProviderFactory, Event event) {
        this.delegate = delegate;
        this.mediaType = mediaType;
        this.cursorStreamProviderFactory = cursorStreamProviderFactory;
        this.event = event;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public Message next() {
        return MessageUtils.toMessage(this.delegate.next(), this.mediaType, this.cursorStreamProviderFactory, this.event);
    }

    @Override
    public boolean hasPrevious() {
        return this.delegate.hasPrevious();
    }

    @Override
    public Message previous() {
        return MessageUtils.toMessage(this.delegate.previous(), this.mediaType, this.cursorStreamProviderFactory, this.event);
    }

    @Override
    public int nextIndex() {
        return this.delegate.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.delegate.previousIndex();
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public void set(Message message) {
        this.delegate.set(Result.builder((Message)message).build());
    }

    @Override
    public void add(Message message) {
        this.delegate.add(Result.builder((Message)message).build());
    }

    @Override
    public void forEachRemaining(Consumer<? super Message> action) {
        this.delegate.forEachRemaining((? super E result) -> action.accept(MessageUtils.toMessage(result, this.mediaType, this.cursorStreamProviderFactory, this.event)));
    }
}

