/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.message;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.NullAttributes;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.streaming.CursorStreamProvider;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.util.message.ResultsToMessageCollection;
import org.mule.runtime.core.util.message.ResultsToMessageList;
import org.mule.runtime.core.util.message.ResultsToMessageSet;
import org.mule.runtime.extension.api.runtime.operation.Result;

public final class MessageUtils {
    private MessageUtils() {
    }

    public static Message toMessage(Result result) {
        return MessageUtils.toMessage(result, result.getMediaType().orElse(MediaType.ANY));
    }

    public static Message toMessage(Result result, MediaType mediaType) {
        return MessageUtils.toMessage(result, mediaType, null, null);
    }

    public static Message toMessage(Result result, MediaType mediaType, CursorStreamProviderFactory cursorStreamProviderFactory, Event event) {
        return Message.builder().payload(MessageUtils.valueOrStreamProvider(result.getOutput(), cursorStreamProviderFactory, event).getValue().orElse(null)).mediaType(mediaType).attributes((Attributes)result.getAttributes().orElse(NullAttributes.NULL_ATTRIBUTES)).build();
    }

    public static <T> Either<CursorStreamProvider, T> valueOrStreamProvider(T value, CursorStreamProviderFactory cursorStreamProviderFactory, Event event) {
        if (cursorStreamProviderFactory != null && value instanceof InputStream) {
            return cursorStreamProviderFactory.of(event, (InputStream)value);
        }
        return Either.right(value);
    }

    public static Collection<Message> toMessageCollection(Collection<Result> results, MediaType mediaType, CursorStreamProviderFactory cursorStreamProviderFactory, Event event) {
        if (results instanceof List) {
            return new ResultsToMessageList((List)results, mediaType, cursorStreamProviderFactory, event);
        }
        if (results instanceof Set) {
            return new ResultsToMessageSet((Set)results, mediaType, cursorStreamProviderFactory, event);
        }
        return new ResultsToMessageCollection(results, mediaType, cursorStreamProviderFactory, event);
    }
}

