/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.counters.impl;

import org.mule.runtime.core.util.counters.CounterFactory;
import org.mule.runtime.core.util.counters.impl.AbstractCounter;
import org.mule.runtime.core.util.counters.impl.AggregateCounter;

public class TimeAverage
extends AggregateCounter {
    private double sum = 0.0;
    private double lastValue = 0.0;
    private final long firstTime;
    private long lastTime = this.firstTime = System.currentTimeMillis();

    public TimeAverage(String name, AbstractCounter base) {
        super(name, CounterFactory.Type.AVERAGE, base);
    }

    @Override
    public double nextValue() {
        long current = System.currentTimeMillis();
        return (this.sum + this.lastValue * (double)(current - this.lastTime)) / (double)(current - this.firstTime);
    }

    @Override
    public void doCompute() {
        long current = System.currentTimeMillis();
        this.sum += this.lastValue * (double)(current - this.lastTime);
        this.lastValue = this.getBase().nextValue();
        this.lastTime = current;
    }
}

