/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.compression;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.compression.CompressionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompressionHelper {
    private static Logger logger = LoggerFactory.getLogger(CompressionHelper.class);
    private static CompressionStrategy defaultStrategy;

    private CompressionHelper() {
    }

    public static synchronized CompressionStrategy getDefaultCompressionStrategy() {
        if (defaultStrategy == null) {
            defaultStrategy = AccessController.doPrivileged(new PrivilegedAction<CompressionStrategy>(){

                @Override
                public CompressionStrategy run() {
                    try {
                        Object o = ClassUtils.loadClass("org.mule.runtime.core.util.compression.GZipCompression", CompressionHelper.class).newInstance();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Found CompressionStrategy: " + o.getClass().getName());
                        }
                        return (CompressionStrategy)o;
                    }
                    catch (Exception e) {
                        logger.warn("Failed to build compression strategy: " + e.getMessage());
                        return null;
                    }
                }
            });
        }
        return defaultStrategy;
    }
}

