/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.annotation;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.core.util.annotation.AnnotationMetaData;

public class AnnotationUtils {
    public static boolean methodHasParamAnnotations(Method method) {
        for (int i = 0; i < method.getParameterAnnotations().length; ++i) {
            if (method.getParameterAnnotations()[i].length <= 0) continue;
            return true;
        }
        return false;
    }

    public static List<AnnotationMetaData> getParamAnnotationsWithMeta(Method method, Class<? extends Annotation> metaAnnotation) {
        ArrayList<AnnotationMetaData> annos = new ArrayList<AnnotationMetaData>();
        for (int i = 0; i < method.getParameterAnnotations().length; ++i) {
            for (int j = 0; j < method.getParameterAnnotations()[i].length; ++j) {
                Annotation annotation = method.getParameterAnnotations()[i][j];
                if (metaAnnotation != null && !annotation.annotationType().isAnnotationPresent(metaAnnotation)) continue;
                annos.add(new AnnotationMetaData(method.getDeclaringClass(), method, ElementType.PARAMETER, annotation));
            }
        }
        return annos;
    }

    public static List<AnnotationMetaData> getMethodAnnotations(Class<?> c, Class<? extends Annotation> ann) {
        return Arrays.asList(c.getMethods()).stream().filter(method -> method.isAnnotationPresent(ann)).map(method -> new AnnotationMetaData(c, (Member)method, ElementType.METHOD, (Annotation)method.getAnnotation(ann))).collect(Collectors.toList());
    }

    public static boolean hasAnnotationWithPackage(String packageName, Class<?> clazz) throws IOException {
        for (Annotation anno : clazz.getDeclaredAnnotations()) {
            if (!anno.annotationType().getPackage().getName().startsWith(packageName)) continue;
            return true;
        }
        for (Field field : clazz.getDeclaredFields()) {
            for (Annotation anno : field.getDeclaredAnnotations()) {
                if (!anno.annotationType().getPackage().getName().startsWith(packageName)) continue;
                return true;
            }
        }
        for (Method method : clazz.getDeclaredMethods()) {
            for (Annotation anno : method.getDeclaredAnnotations()) {
                if (!anno.annotationType().getPackage().getName().startsWith(packageName)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T extends Annotation> Optional<T> getAnnotation(Class<?> aClass, Class<T> annotationType) {
        return aClass != null ? Optional.ofNullable(aClass.getAnnotation(annotationType)) : Optional.empty();
    }
}

