/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.processor.strategy.DefaultFlowProcessingStrategyFactory;
import org.mule.runtime.core.processor.strategy.LegacyAsynchronousProcessingStrategyFactory;
import org.mule.runtime.core.processor.strategy.LegacyNonBlockingProcessingStrategyFactory;
import org.mule.runtime.core.processor.strategy.SynchronousProcessingStrategyFactory;

public class ProcessingStrategyUtils {
    public static String DEFAULT_PROCESSING_STRATEGY = "default";
    public static String SYNC_PROCESSING_STRATEGY = "synchronous";
    public static String NON_BLOCKING_PROCESSING_STRATEGY = "non-blocking";
    public static String ASYNC_PROCESSING_STRATEGY = "asynchronous";

    public static ProcessingStrategyFactory parseProcessingStrategy(String processingStrategy) {
        if (DEFAULT_PROCESSING_STRATEGY.equals(processingStrategy)) {
            return new DefaultFlowProcessingStrategyFactory();
        }
        if (SYNC_PROCESSING_STRATEGY.equals(processingStrategy)) {
            return new SynchronousProcessingStrategyFactory();
        }
        if (NON_BLOCKING_PROCESSING_STRATEGY.equals(processingStrategy)) {
            return new LegacyNonBlockingProcessingStrategyFactory();
        }
        if (ASYNC_PROCESSING_STRATEGY.equals(processingStrategy)) {
            return new LegacyAsynchronousProcessingStrategyFactory();
        }
        return null;
    }
}

