/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.transformer.AbstractTransformer;
import org.mule.runtime.core.util.StringUtils;

public class ObjectArrayToString
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 2;
    private static final String DEFAULT_DELIMITER = " ";
    private String delimiter = null;

    public ObjectArrayToString() {
        this.registerSourceType(DataType.fromType(Object[].class));
        this.setReturnDataType(DataType.STRING);
    }

    @Override
    public Object doTransform(Object src, Charset encoding) throws TransformerException {
        if (src == null) {
            return src;
        }
        Object[] in = (Object[])src;
        String out = StringUtils.join((Object[])in, (String)this.getDelimiter());
        return out;
    }

    public String getDelimiter() {
        if (this.delimiter == null) {
            return DEFAULT_DELIMITER;
        }
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

