/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transaction.lookup;

import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.transaction.TransactionManagerFactory;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.JndiContextHelper;
import org.mule.runtime.core.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericTransactionManagerLookupFactory
implements TransactionManagerFactory,
Initialisable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Context context;
    private Map environment;
    private TransactionManager txManager;
    private String jndiName;

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public TransactionManager getTxManager() {
        return this.txManager;
    }

    public void setTxManager(TransactionManager txManager) {
        this.txManager = txManager;
    }

    public Map getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map environment) {
        this.environment = environment;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public TransactionManager create(MuleConfiguration config) throws Exception {
        this.initialise();
        if (this.txManager == null) {
            this.txManager = (TransactionManager)this.context.lookup(this.jndiName);
        }
        return this.txManager;
    }

    public void initialise() throws InitialisationException {
        if (this.txManager == null && StringUtils.isEmpty((String)StringUtils.trim((String)this.jndiName))) {
            throw new InitialisationException(CoreMessages.propertiesNotSet("jndiName"), (Initialisable)this);
        }
        try {
            if (this.context == null) {
                this.context = JndiContextHelper.initialise(this.getEnvironment());
            }
        }
        catch (NamingException e) {
            throw new InitialisationException(CoreMessages.failedToCreate("Jndi context"), (Throwable)e, (Initialisable)this);
        }
    }
}

