/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transaction;

import java.text.MessageFormat;
import javax.transaction.Transaction;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.context.notification.TransactionNotification;
import org.mule.runtime.core.transaction.IllegalTransactionStateException;
import org.mule.runtime.core.transaction.TransactionCoordination;
import org.mule.runtime.core.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransaction
implements org.mule.runtime.core.api.transaction.Transaction {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String id = UUID.getUUID();
    protected int timeout;
    protected MuleContext muleContext;

    protected AbstractTransaction(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public boolean isRollbackOnly() throws TransactionException {
        int status = this.getStatus();
        return status == 1 || status == 4 || status == 9;
    }

    @Override
    public boolean isBegun() throws TransactionException {
        int status = this.getStatus();
        return status != 6 && status != 5;
    }

    @Override
    public boolean isRolledBack() throws TransactionException {
        return this.getStatus() == 4;
    }

    @Override
    public boolean isCommitted() throws TransactionException {
        return this.getStatus() == 3;
    }

    @Override
    public void begin() throws TransactionException {
        this.logger.debug("Beginning transaction");
        this.doBegin();
        TransactionCoordination.getInstance().bindTransaction(this);
        this.fireNotification(new TransactionNotification(this, 1201, this.getApplicationName()));
    }

    @Override
    public void commit() throws TransactionException {
        try {
            this.logger.debug("Committing transaction " + this);
            if (this.isRollbackOnly()) {
                throw new IllegalTransactionStateException(CoreMessages.transactionMarkedForRollback());
            }
            this.doCommit();
            this.fireNotification(new TransactionNotification(this, 1202, this.getApplicationName()));
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction(this);
        }
    }

    @Override
    public void rollback() throws TransactionException {
        try {
            this.logger.debug("Rolling back transaction");
            this.setRollbackOnly();
            this.doRollback();
            this.fireNotification(new TransactionNotification(this, 1203, this.getApplicationName()));
        }
        finally {
            this.unbindTransaction();
        }
    }

    protected void unbindTransaction() throws TransactionException {
        TransactionCoordination.getInstance().unbindTransaction(this);
    }

    protected abstract void doBegin() throws TransactionException;

    protected abstract void doCommit() throws TransactionException;

    protected abstract void doRollback() throws TransactionException;

    protected void fireNotification(TransactionNotification notification) {
        this.muleContext.fireNotification(notification);
    }

    @Override
    public boolean isXA() {
        return false;
    }

    @Override
    public void resume() throws TransactionException {
        throw new IllegalTransactionStateException(CoreMessages.notMuleXaTransaction(this));
    }

    @Override
    public Transaction suspend() throws TransactionException {
        throw new IllegalTransactionStateException(CoreMessages.notMuleXaTransaction(this));
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        int status;
        try {
            status = this.getStatus();
        }
        catch (TransactionException e) {
            status = -1;
        }
        return MessageFormat.format("{0}[id={1} , status={2}]", this.getClass().getName(), this.id, status);
    }

    private String getApplicationName() {
        return this.muleContext.getConfiguration().getId();
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

