/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.source.polling.watermark.selector;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.session.DefaultMuleSession;
import org.mule.runtime.core.source.polling.watermark.WatermarkUtils;
import org.mule.runtime.core.source.polling.watermark.selector.WatermarkSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatermarkSelectorWrapper
extends WatermarkSelector {
    private static final Logger logger = LoggerFactory.getLogger(WatermarkSelectorWrapper.class);
    private final String selectorExpression;
    private final WatermarkSelector wrapped;
    private final Event muleEvent;
    private MuleContext muleContext;

    protected WatermarkSelectorWrapper(WatermarkSelector wrapped, String selectorExpression, Event muleEvent, MuleContext muleContext) {
        this.selectorExpression = selectorExpression;
        this.wrapped = wrapped;
        this.muleEvent = Event.builder(muleEvent).session(new DefaultMuleSession(muleEvent.getSession())).build();
        this.muleContext = muleContext;
    }

    @Override
    public void acceptValue(Object value) {
        try {
            Serializable evaluated = WatermarkUtils.evaluate(this.selectorExpression, Event.builder(this.muleEvent).message(InternalMessage.builder(this.muleEvent.getMessage()).payload(value).build()).build(), this.muleContext);
            this.wrapped.acceptValue(evaluated);
        }
        catch (NotSerializableException e) {
            logger.warn(String.format("Watermark selector expression '%s' did not resolved to a Serializable value. Value will be ignored", this.selectorExpression), (Throwable)e);
        }
    }

    @Override
    public Object getSelectedValue() {
        return this.wrapped.getSelectedValue();
    }

    @Override
    public void reset() {
        this.wrapped.reset();
    }
}

