/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.source.polling.watermark;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.ProcessingDescriptor;
import org.mule.runtime.core.api.store.ObjectStoreException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.source.polling.MessageProcessorPollingInterceptor;
import org.mule.runtime.core.source.polling.watermark.Watermark;

public class WatermarkPollingInterceptor
extends MessageProcessorPollingInterceptor {
    protected final Watermark watermark;

    public WatermarkPollingInterceptor(Watermark watermark) {
        this.watermark = watermark;
    }

    @Override
    public Event prepareSourceEvent(Event event) throws MuleException {
        return this.watermark.putInto(event);
    }

    @Override
    public Event prepareRouting(Event sourceEvent, Event event, FlowConstruct flow) throws ConfigurationException {
        if (!(flow instanceof ProcessingDescriptor) || !((ProcessingDescriptor)((Object)flow)).isSynchronous()) {
            throw new ConfigurationException(CoreMessages.watermarkRequiresSynchronousProcessing());
        }
        String variableName = this.watermark.resolveVariable(event);
        return Event.builder(event).addVariable(variableName, sourceEvent.getVariable(variableName).getValue()).build();
    }

    @Override
    public void postProcessRouting(Event event) throws ObjectStoreException {
        this.watermark.updateFrom(event);
    }
}

