/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing.outbound;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.DispatchException;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessorPathElement;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.OutboundRouter;
import org.mule.runtime.core.api.routing.RouterResultsHandler;
import org.mule.runtime.core.api.routing.RoutingException;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.MessageProcessorExecutionTemplate;
import org.mule.runtime.core.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.management.stats.RouterStatistics;
import org.mule.runtime.core.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.routing.AbstractRoutingStrategy;
import org.mule.runtime.core.routing.DefaultRouterResultsHandler;
import org.mule.runtime.core.util.NotificationUtils;
import org.mule.runtime.core.util.StringMessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOutboundRouter
extends AbstractMessageProcessorOwner
implements OutboundRouter {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected List<Processor> routes = new CopyOnWriteArrayList<Processor>();
    protected TransactionConfig transactionConfig;
    protected RouterResultsHandler resultsHandler = new DefaultRouterResultsHandler();
    private RouterStatistics routerStatistics;
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected AtomicBoolean started = new AtomicBoolean(false);
    private MessageProcessorExecutionTemplate notificationTemplate = MessageProcessorExecutionTemplate.createNotificationExecutionTemplate();

    @Override
    public Event process(Event event) throws MuleException {
        TransactionalExecutionTemplate<Event> executionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate(this.muleContext, this.getTransactionConfig());
        ExecutionCallback<Event> processingCallback = () -> {
            try {
                return this.route(event);
            }
            catch (RoutingException e1) {
                throw e1;
            }
            catch (Exception e2) {
                throw new RoutingException(this, e2);
            }
        };
        try {
            return executionTemplate.execute(processingCallback);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException(e);
        }
    }

    protected abstract Event route(Event var1) throws MuleException;

    protected final Event sendRequest(Event originalEvent, Event eventToRoute, Processor route, boolean awaitResponse) throws MuleException {
        Event result;
        try {
            result = this.sendRequestEvent(originalEvent, eventToRoute, route, awaitResponse);
        }
        catch (MessagingException me) {
            throw me;
        }
        catch (Exception e) {
            throw new RoutingException(null, e);
        }
        if (this.getRouterStatistics() != null && this.getRouterStatistics().isEnabled()) {
            this.getRouterStatistics().incrementRoutedMessage(route);
        }
        if (result != null) {
            InternalMessage resultMessage = result.getMessage();
            if (this.logger.isTraceEnabled() && resultMessage != null) {
                try {
                    this.logger.trace("Response payload: \n" + StringMessageUtils.truncate(this.muleContext.getTransformationService().getPayloadForLogging(resultMessage), 100, false));
                }
                catch (Exception e) {
                    this.logger.trace("Response payload: \n(unable to retrieve payload: " + e.getMessage());
                }
            }
        }
        return result;
    }

    @Override
    public List<Processor> getRoutes() {
        return this.routes;
    }

    @Deprecated
    public void setMessageProcessors(List<Processor> routes) throws MuleException {
        this.setRoutes(routes);
    }

    public void setRoutes(List<Processor> routes) throws MuleException {
        this.routes.clear();
        for (Processor route : routes) {
            this.addRoute(route);
        }
    }

    @Override
    public synchronized void addRoute(Processor route) throws MuleException {
        if (this.initialised.get()) {
            if (route instanceof MuleContextAware) {
                ((MuleContextAware)((Object)route)).setMuleContext(this.muleContext);
            }
            if (route instanceof FlowConstructAware) {
                ((FlowConstructAware)((Object)route)).setFlowConstruct(this.flowConstruct);
            }
            if (route instanceof Initialisable) {
                ((Initialisable)route).initialise();
            }
        }
        if (this.started.get() && route instanceof Startable) {
            ((Startable)route).start();
        }
        this.routes.add(route);
    }

    @Override
    public synchronized void removeRoute(Processor route) throws MuleException {
        if (this.started.get() && route instanceof Stoppable) {
            ((Stoppable)route).stop();
        }
        if (this.initialised.get() && route instanceof Disposable) {
            ((Disposable)route).dispose();
        }
        this.routes.remove(route);
    }

    public TransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    @Override
    public void setTransactionConfig(TransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    @Override
    public boolean isDynamicRoutes() {
        return false;
    }

    public RouterResultsHandler getResultsHandler() {
        return this.resultsHandler;
    }

    public void setResultsHandler(RouterResultsHandler resultsHandler) {
        this.resultsHandler = resultsHandler;
    }

    protected Event sendRequestEvent(Event originalEvent, Event eventToRoute, Processor route, boolean awaitResponse) throws MuleException {
        if (route == null) {
            throw new DispatchException(CoreMessages.objectIsNull("connector operation"), null);
        }
        return this.doProcessRoute(route, eventToRoute);
    }

    protected Event doProcessRoute(Processor route, Event event) throws MuleException, MessagingException {
        if (route instanceof MessageProcessorChain) {
            return route.process(event);
        }
        return this.notificationTemplate.execute(route, event);
    }

    protected Event createEventToRoute(Event routedEvent, InternalMessage message) {
        return Event.builder(routedEvent).message(message).build();
    }

    protected InternalMessage cloneMessage(Event event, InternalMessage message) throws MuleException {
        return AbstractRoutingStrategy.cloneMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise() throws InitialisationException {
        List<Processor> list = this.routes;
        synchronized (list) {
            super.initialise();
            this.initialised.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<Processor> list = this.routes;
        synchronized (list) {
            super.dispose();
            this.routes = Collections.emptyList();
            this.initialised.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws MuleException {
        List<Processor> list = this.routes;
        synchronized (list) {
            super.start();
            this.started.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws MuleException {
        List<Processor> list = this.routes;
        synchronized (list) {
            super.stop();
            this.started.set(false);
        }
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public void setRouterStatistics(RouterStatistics stats) {
        this.routerStatistics = stats;
    }

    public RouterStatistics getRouterStatistics() {
        return this.routerStatistics;
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return this.routes;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
        this.notificationTemplate.setMuleContext(context);
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
        this.notificationTemplate.setFlowConstruct(flowConstruct);
    }

    @Override
    public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
        NotificationUtils.addMessageProcessorPathElements(this.getOwnedMessageProcessors(), pathElement.addChild(this));
    }
}

