/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.RoutePathNotFoundException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.routing.AbstractRoutingStrategy;
import org.mule.runtime.core.routing.IdentifiableDynamicRouteResolver;
import org.mule.runtime.core.routing.RoutingFailedException;

public class RoundRobinRoutingStrategy
extends AbstractRoutingStrategy {
    private final IdentifiableDynamicRouteResolver identifiableDynamicRouteResolver;
    private Map<String, Short> roundRobinState = new HashMap<String, Short>();

    public RoundRobinRoutingStrategy(MuleContext muleContext, IdentifiableDynamicRouteResolver identifiableDynamicRouteResolver) {
        super(muleContext);
        this.identifiableDynamicRouteResolver = identifiableDynamicRouteResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Event route(Event event, List<Processor> messageProcessors) throws MuleException {
        if (messageProcessors == null || messageProcessors.isEmpty()) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), null);
        }
        String id = this.identifiableDynamicRouteResolver.getRouteIdentifier(event);
        Short nextMessageProcessor = 0;
        RoundRobinRoutingStrategy roundRobinRoutingStrategy = this;
        synchronized (roundRobinRoutingStrategy) {
            if (this.roundRobinState.containsKey(id)) {
                Short lastMessageProcessor = this.roundRobinState.get(id);
                nextMessageProcessor = (short)(lastMessageProcessor + 1 >= messageProcessors.size() ? 0 : lastMessageProcessor + 1);
                this.roundRobinState.put(id, nextMessageProcessor);
            } else {
                this.roundRobinState.put(id, (short)0);
            }
        }
        Processor mp = messageProcessors.get(nextMessageProcessor.shortValue());
        Event eventCopy = this.cloneEventForRouting(event, mp);
        try {
            return mp.process(eventCopy);
        }
        catch (MuleException me) {
            throw new RoutingFailedException(CoreMessages.createStaticMessage((String)"Error processing event"), me);
        }
    }

    private Event cloneEventForRouting(Event event, Processor mp) throws MuleException {
        return this.createEventToRoute(event, RoundRobinRoutingStrategy.cloneMessage(event.getMessage()), mp);
    }
}

